/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.AbstractQueryDefinition;
import com.marklogic.client.impl.CombinedQueryBuilder;
import com.marklogic.client.impl.CombinedQueryDefinition;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.HandleImplementation;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.QueryOptionsWriteHandle;
import com.marklogic.client.query.StructuredQueryDefinition;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class CombinedQueryBuilderImpl
implements CombinedQueryBuilder {
    @Override
    public CombinedQueryDefinition combine(StructuredQueryDefinition query, String qtext) {
        return new CombinedQueryDefinitionImpl(query, null, qtext);
    }

    @Override
    public CombinedQueryDefinition combine(StructuredQueryDefinition query, QueryOptionsWriteHandle options) {
        return new CombinedQueryDefinitionImpl(query, options, null);
    }

    @Override
    public CombinedQueryDefinition combine(StructuredQueryDefinition query, QueryOptionsWriteHandle options, String qtext) {
        return new CombinedQueryDefinitionImpl(query, options, qtext);
    }

    private String serialize(CombinedQueryDefinitionImpl combinedQueryDefinitionImpl) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeCombinedQuery(baos, combinedQueryDefinitionImpl);
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            throw new MarkLogicIOException(e);
        }
    }

    private XMLStreamWriter makeSerializer(OutputStream out) {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        try {
            XMLStreamWriter serializer = factory.createXMLStreamWriter(out, "UTF-8");
            serializer.setDefaultNamespace("http://marklogic.com/appservices/search");
            serializer.setPrefix("xs", "http://www.w3.org/2001/XMLSchema");
            return serializer;
        }
        catch (Exception e) {
            throw new MarkLogicIOException(e);
        }
    }

    private void writeCombinedQuery(OutputStream out, CombinedQueryDefinitionImpl combinedQueryDefinitionImpl) {
        try {
            String qtext = combinedQueryDefinitionImpl.qtext;
            StructuredQueryDefinition query = combinedQueryDefinitionImpl.query;
            QueryOptionsWriteHandle options = combinedQueryDefinitionImpl.options;
            XMLStreamWriter serializer = this.makeSerializer(out);
            serializer.writeStartDocument();
            serializer.writeStartElement("search");
            if (qtext != null) {
                serializer.writeStartElement("qtext");
                serializer.writeCharacters(qtext);
                serializer.writeEndElement();
            } else {
                serializer.writeCharacters("");
            }
            serializer.flush();
            if (query != null) {
                String structure = query.serialize();
                out.write(structure.getBytes("UTF-8"));
                out.flush();
            }
            if (options != null) {
                HandleImplementation handleBase = HandleAccessor.as(options);
                Object value = handleBase.sendContent();
                if (value instanceof OutputStreamSender) {
                    ((OutputStreamSender)value).write(out);
                } else {
                    out.write(value.toString().getBytes("UTF-8"));
                }
                out.flush();
            }
            serializer.writeEndElement();
            serializer.writeEndDocument();
            serializer.flush();
            serializer.close();
        }
        catch (Exception e) {
            throw new MarkLogicIOException(e);
        }
    }

    public class CombinedQueryDefinitionImpl
    extends AbstractQueryDefinition
    implements CombinedQueryDefinition {
        private StructuredQueryDefinition query;
        private QueryOptionsWriteHandle options;
        private String qtext;

        public CombinedQueryDefinitionImpl(StructuredQueryDefinition query, QueryOptionsWriteHandle options, String qtext) {
            this.query = query;
            this.options = options;
            this.qtext = qtext;
        }

        @Override
        public String serialize() {
            return CombinedQueryBuilderImpl.this.serialize(this);
        }
    }
}

