/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import java.util.HashMap;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class QueryOptionsTransformExtractNS
extends XMLFilterImpl {
    private static final String SEARCH_NS = "http://marklogic.com/appservices/search";
    private HashMap<String, String> nsmap = new HashMap();

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nsmap.put(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String ename = "namespace-bindings";
        if (SEARCH_NS.equals(uri) && ("path-index".equals(localName) || "searchable-expression".equals(localName))) {
            if ("searchable-expression".equals(localName)) {
                // empty if block
            }
            super.startElement(SEARCH_NS, ename, ename, null);
            for (String pfx : this.nsmap.keySet()) {
                BindingAttributes attrs = new BindingAttributes();
                attrs.addAttribute("prefix", pfx);
                attrs.addAttribute("namespace-uri", this.nsmap.get(pfx));
                super.startElement(SEARCH_NS, "binding", "binding", attrs);
                super.endElement(SEARCH_NS, "binding", "binding");
            }
            super.endElement(SEARCH_NS, ename, ename);
        }
        super.startElement(uri, localName, qName, attributes);
        this.nsmap.clear();
    }

    private static class BindingAttributes
    implements Attributes {
        private Vector<String> names = new Vector();
        private Vector<String> values = new Vector();

        public void addAttribute(String prefix, String uri) {
            this.names.add(prefix);
            this.values.add(uri);
        }

        @Override
        public int getLength() {
            return this.names.size();
        }

        @Override
        public String getURI(int i) {
            return this.values.get(i);
        }

        @Override
        public String getLocalName(int i) {
            return this.names.get(i);
        }

        @Override
        public String getQName(int i) {
            return this.names.get(i);
        }

        @Override
        public String getType(int i) {
            return "CDATA";
        }

        @Override
        public String getValue(int i) {
            return this.values.get(i);
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (uri != null && !"".equals(uri)) {
                return -1;
            }
            for (int i = 0; i < this.names.size(); ++i) {
                if (!localName.equals(this.names.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String qName) {
            for (int i = 0; i < this.names.size(); ++i) {
                if (!qName.equals(this.names.get(i))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String uri, String localName) {
            if (this.getIndex(uri, localName) >= 0) {
                return "CDATA";
            }
            return null;
        }

        @Override
        public String getType(String qName) {
            if (this.getIndex(qName) >= 0) {
                return "CDATA";
            }
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            int pos = this.getIndex(uri, localName);
            if (pos >= 0) {
                return this.getValue(pos);
            }
            return null;
        }

        @Override
        public String getValue(String qName) {
            int pos = this.getIndex(qName);
            if (pos >= 0) {
                return this.getValue(pos);
            }
            return null;
        }
    }
}

