/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.Transaction;
import com.marklogic.client.eval.EvalResultIterator;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.util.EditableNamespaceContext;
import java.util.HashMap;

public class ServerEvaluationCallImpl
extends AbstractLoggingManager
implements ServerEvaluationCall {
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;
    private String code;
    private String modulePath;
    private Context evalContext;
    private Transaction transaction;
    private HashMap<String, Object> vars = new HashMap();
    private EditableNamespaceContext namespaceContext;

    public ServerEvaluationCallImpl(RESTServices services, DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.services = services;
        this.handleRegistry = handleRegistry;
    }

    @Override
    public ServerEvaluationCall xquery(String xquery) {
        this.setContext(Context.ADHOC_XQUERY);
        this.code = xquery;
        return this;
    }

    @Override
    public ServerEvaluationCall xquery(TextWriteHandle xquery) {
        this.setContext(Context.ADHOC_XQUERY);
        this.code = HandleAccessor.contentAsString(xquery);
        return this;
    }

    @Override
    public ServerEvaluationCall javascript(String javascript) {
        this.setContext(Context.ADHOC_JAVASCRIPT);
        this.code = javascript;
        return this;
    }

    @Override
    public ServerEvaluationCall javascript(TextWriteHandle javascript) {
        this.setContext(Context.ADHOC_JAVASCRIPT);
        this.code = HandleAccessor.contentAsString(javascript);
        return this;
    }

    @Override
    public ServerEvaluationCall modulePath(String modulePath) {
        this.setContext(Context.INVOKE);
        this.modulePath = modulePath;
        return this;
    }

    @Override
    public ServerEvaluationCall addVariable(String name, String value) {
        this.vars.put(name, value);
        return this;
    }

    @Override
    public ServerEvaluationCall addVariable(String name, Number value) {
        this.vars.put(name, value);
        return this;
    }

    @Override
    public ServerEvaluationCall addVariable(String name, Boolean value) {
        this.vars.put(name, value);
        return this;
    }

    @Override
    public ServerEvaluationCall addVariable(String name, AbstractWriteHandle value) {
        this.vars.put(name, value);
        return this;
    }

    @Override
    public ServerEvaluationCall addVariableAs(String name, Object value) {
        if (value == null) {
            return this;
        }
        Class<?> as = value.getClass();
        ContentHandle<?> writeHandle = null;
        if (AbstractWriteHandle.class.isAssignableFrom(as)) {
            writeHandle = (ContentHandle<?>)value;
        } else {
            ContentHandle<?> contentHandle = this.handleRegistry.makeHandle(as);
            Utilities.setHandleContent(contentHandle, value);
            writeHandle = contentHandle;
        }
        return this.addVariable(name, writeHandle);
    }

    @Override
    public ServerEvaluationCall transaction(Transaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
        }
        return this;
    }

    @Override
    public <T> T evalAs(Class<T> responseType) throws ForbiddenUserException, FailedRequestException {
        if (responseType == null) {
            throw new IllegalArgumentException("responseType cannot be null");
        }
        ContentHandle<T> readHandle = this.handleRegistry.makeHandle(responseType);
        if (readHandle == null) {
            return null;
        }
        if ((readHandle = this.eval(readHandle)) == null) {
            return null;
        }
        return readHandle.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <H extends AbstractReadHandle> H eval(H responseHandle) throws ForbiddenUserException, FailedRequestException {
        EvalResultIterator iterator = this.eval();
        try {
            if (iterator == null || !iterator.hasNext()) {
                H h = null;
                return h;
            }
            H h = iterator.next().get(responseHandle);
            return h;
        }
        finally {
            iterator.close();
        }
    }

    @Override
    public EvalResultIterator eval() throws ForbiddenUserException, FailedRequestException {
        return this.services.postEvalInvoke(this.requestLogger, this.code, this.modulePath, this.evalContext, this.vars, this.namespaceContext, this.transaction);
    }

    @Override
    public ServerEvaluationCall addNamespace(String prefix, String namespaceURI) {
        if (this.namespaceContext == null) {
            this.namespaceContext = new EditableNamespaceContext();
        }
        this.namespaceContext.put(prefix, namespaceURI);
        return this;
    }

    @Override
    public ServerEvaluationCall namespaceContext(EditableNamespaceContext namespaces) {
        this.namespaceContext = namespaces;
        return this;
    }

    private void setContext(Context context) {
        if (this.evalContext != null) {
            throw new IllegalStateException("You can only initialize the code to evaluate one time. That means only one call to the xquery, javascript, xqueryModule, or javascriptModule methods per ServerEvaluationCall.");
        }
        this.evalContext = context;
    }

    public static enum Context {
        ADHOC_XQUERY,
        ADHOC_JAVASCRIPT,
        INVOKE;

    }
}

