/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.FailedRequestException;
import com.marklogic.client.ForbiddenUserException;
import com.marklogic.client.Transaction;
import com.marklogic.client.admin.ServerConfigurationManager;
import com.marklogic.client.alerting.RuleManager;
import com.marklogic.client.document.BinaryDocumentManager;
import com.marklogic.client.document.GenericDocumentManager;
import com.marklogic.client.document.JSONDocumentManager;
import com.marklogic.client.document.TextDocumentManager;
import com.marklogic.client.document.XMLDocumentManager;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.extensions.ResourceManager;
import com.marklogic.client.impl.BinaryDocumentImpl;
import com.marklogic.client.impl.GenericDocumentImpl;
import com.marklogic.client.impl.GraphManagerImpl;
import com.marklogic.client.impl.JSONDocumentImpl;
import com.marklogic.client.impl.PojoRepositoryImpl;
import com.marklogic.client.impl.QueryManagerImpl;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.RequestLoggerImpl;
import com.marklogic.client.impl.ResourceServicesImpl;
import com.marklogic.client.impl.RuleManagerImpl;
import com.marklogic.client.impl.SPARQLQueryManagerImpl;
import com.marklogic.client.impl.ServerConfigurationManagerImpl;
import com.marklogic.client.impl.ServerEvaluationCallImpl;
import com.marklogic.client.impl.TextDocumentImpl;
import com.marklogic.client.impl.XMLDocumentImpl;
import com.marklogic.client.pojo.PojoRepository;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.semantics.GraphManager;
import com.marklogic.client.semantics.SPARQLQueryManager;
import com.marklogic.client.util.RequestLogger;
import java.io.OutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseClientImpl
implements DatabaseClient {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseClientImpl.class);
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;

    public DatabaseClientImpl(RESTServices services) {
        this.services = services;
        services.setDatabaseClient(this);
    }

    public DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    public void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public Transaction openTransaction() throws ForbiddenUserException, FailedRequestException {
        return this.services.openTransaction(null, -1);
    }

    @Override
    public Transaction openTransaction(String name) throws ForbiddenUserException, FailedRequestException {
        return this.services.openTransaction(name, -1);
    }

    @Override
    public Transaction openTransaction(String name, int timeLimit) throws ForbiddenUserException, FailedRequestException {
        return this.services.openTransaction(name, timeLimit);
    }

    @Override
    public GenericDocumentManager newDocumentManager() {
        GenericDocumentImpl docMgr = new GenericDocumentImpl(this.services);
        docMgr.setHandleRegistry(this.getHandleRegistry());
        return docMgr;
    }

    @Override
    public BinaryDocumentManager newBinaryDocumentManager() {
        BinaryDocumentImpl docMgr = new BinaryDocumentImpl(this.services);
        docMgr.setHandleRegistry(this.getHandleRegistry());
        return docMgr;
    }

    @Override
    public JSONDocumentManager newJSONDocumentManager() {
        JSONDocumentImpl docMgr = new JSONDocumentImpl(this.services);
        docMgr.setHandleRegistry(this.getHandleRegistry());
        return docMgr;
    }

    @Override
    public TextDocumentManager newTextDocumentManager() {
        TextDocumentImpl docMgr = new TextDocumentImpl(this.services);
        docMgr.setHandleRegistry(this.getHandleRegistry());
        return docMgr;
    }

    @Override
    public XMLDocumentManager newXMLDocumentManager() {
        XMLDocumentImpl docMgr = new XMLDocumentImpl(this.services);
        docMgr.setHandleRegistry(this.getHandleRegistry());
        return docMgr;
    }

    @Override
    public RuleManager newRuleManager() {
        RuleManagerImpl ruleMgr = new RuleManagerImpl(this.services);
        ruleMgr.setHandleRegistry(this.getHandleRegistry());
        return ruleMgr;
    }

    @Override
    public QueryManager newQueryManager() {
        QueryManagerImpl queryMgr = new QueryManagerImpl(this.services);
        queryMgr.setHandleRegistry(this.getHandleRegistry());
        return queryMgr;
    }

    @Override
    public ServerConfigurationManager newServerConfigManager() {
        ServerConfigurationManagerImpl configMgr = new ServerConfigurationManagerImpl(this.services);
        configMgr.setHandleRegistry(this.getHandleRegistry());
        return configMgr;
    }

    @Override
    public <T, ID extends Serializable> PojoRepository<T, ID> newPojoRepository(Class<T> clazz, Class<ID> idClass) {
        return new PojoRepositoryImpl<T, ID>(this, clazz, idClass);
    }

    @Override
    public RequestLogger newLogger(OutputStream out) {
        return new RequestLoggerImpl(out);
    }

    @Override
    public <T extends ResourceManager> T init(String resourceName, T resourceManager) {
        if (resourceManager == null) {
            throw new IllegalArgumentException("Cannot initialize null resource manager");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Cannot initialize resource manager with null resource name");
        }
        if (resourceName.length() == 0) {
            throw new IllegalArgumentException("Cannot initialize resource manager with empty resource name");
        }
        resourceManager.init(new ResourceServicesImpl(this.services, resourceName));
        return resourceManager;
    }

    @Override
    public void release() {
        if (logger.isInfoEnabled()) {
            logger.info("Releasing connection");
        }
        if (this.services != null) {
            this.services.release();
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @Override
    public Object getClientImplementation() {
        if (this.services == null) {
            return null;
        }
        return this.services.getClientImplementation();
    }

    public RESTServices getServices() {
        return this.services;
    }

    @Override
    public ServerEvaluationCall newServerEval() {
        return new ServerEvaluationCallImpl(this.services, this.getHandleRegistry());
    }

    @Override
    public GraphManager newGraphManager() {
        return new GraphManagerImpl(this.services, this.getHandleRegistry());
    }

    @Override
    public SPARQLQueryManager newSPARQLQueryManager() {
        return new SPARQLQueryManagerImpl(this.services);
    }
}

