/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.FailedRequestParser;
import com.marklogic.client.io.JSONErrorParser;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FailedRequest {
    private String messageCode;
    private String messageString;
    private int statusCode;
    private String statusString;

    public static FailedRequest getFailedRequest(int httpStatus, MediaType contentType, InputStream content) {
        FailedRequest failure;
        if (MediaType.APPLICATION_XML_TYPE.isCompatible(contentType)) {
            FailedRequestXMLParser xmlParser = new FailedRequestXMLParser();
            failure = xmlParser.parseFailedRequest(httpStatus, content);
        } else if (MediaType.APPLICATION_JSON_TYPE.isCompatible(contentType)) {
            failure = FailedRequest.jsonFailedRequest(httpStatus, content);
        } else if (contentType == null && httpStatus == 404) {
            failure = new FailedRequest();
            failure.setStatusCode(httpStatus);
            failure.setMessageString("");
            failure.setStatusString("Not Found");
        } else {
            failure = new FailedRequest();
            failure.setStatusCode(httpStatus);
            failure.setMessageCode("UNKNOWN");
            failure.setMessageString("Server (not a REST instance?) did not respond with an expected REST Error message.");
            failure.setStatusString("UNKNOWN");
        }
        if (failure.getStatusCode() == 401) {
            failure.setMessageString("Unauthorized");
            failure.setStatusString("Failed Auth");
        }
        return failure;
    }

    private static FailedRequest jsonFailedRequest(int httpStatus, InputStream content) {
        return new JSONErrorParser().parseFailedRequest(httpStatus, content);
    }

    public String getMessage() {
        return this.messageString;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public String getStatus() {
        return this.statusString;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public void setMessageString(String messageString) {
        this.messageString = messageString;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
    }

    private static class FailedRequestXMLParser
    implements FailedRequestParser {
        private FailedRequestXMLParser() {
        }

        @Override
        public FailedRequest parseFailedRequest(int httpStatus, InputStream is) {
            FailedRequest failure = new FailedRequest();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                NodeList messageCodes;
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                String statusCode = null;
                NodeList statusCodes = doc.getElementsByTagNameNS("http://marklogic.com/xdmp/error", "status-code");
                if (statusCodes != null && statusCodes.getLength() > 0) {
                    statusCode = statusCodes.item(0).getTextContent();
                }
                if (statusCode != null) {
                    failure.setStatusCode(Integer.parseInt(statusCode));
                } else {
                    failure.setStatusCode(httpStatus);
                }
                NodeList statuses = doc.getElementsByTagNameNS("http://marklogic.com/xdmp/error", "status");
                if (statuses != null && statuses.getLength() > 0) {
                    failure.setStatusString(statuses.item(0).getTextContent());
                }
                if ((messageCodes = doc.getElementsByTagNameNS("http://marklogic.com/xdmp/error", "message-code")) != null && messageCodes.getLength() > 0) {
                    failure.setMessageCode(messageCodes.item(0).getTextContent());
                }
                String formatString = null;
                NodeList formatStrings = doc.getElementsByTagNameNS("http://marklogic.com/xdmp/error", "format-string");
                if (formatStrings != null && formatStrings.getLength() > 0) {
                    formatString = formatStrings.item(0).getTextContent();
                }
                if (formatString != null) {
                    failure.setMessageString(formatString);
                } else {
                    NodeList messageStrings = doc.getElementsByTagNameNS("http://marklogic.com/xdmp/error", "message");
                    if (messageStrings != null && messageStrings.getLength() > 0) {
                        failure.setMessageString(messageStrings.item(0).getTextContent());
                    }
                }
            }
            catch (ParserConfigurationException e) {
                failure.setStatusCode(httpStatus);
                failure.setMessageString("Request failed. Unable to parse server error.");
            }
            catch (SAXException e) {
                failure.setStatusCode(httpStatus);
                failure.setMessageString("Request failed. Unable to parse server error details");
            }
            catch (IOException e) {
                failure.setStatusCode(httpStatus);
                failure.setMessageString("Request failed. Error body not received from server");
            }
            return failure;
        }
    }
}

