/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.marklogic.client.impl.CombinedQueryBuilderImpl;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.QueryOptionsWriteHandle;
import com.marklogic.client.pojo.PojoQueryBuilder;
import com.marklogic.client.pojo.PojoQueryDefinition;
import com.marklogic.client.query.StructuredQueryBuilder;
import com.marklogic.client.query.StructuredQueryDefinition;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashMap;
import javax.xml.stream.XMLStreamWriter;

public class PojoQueryBuilderImpl<T>
extends StructuredQueryBuilder
implements PojoQueryBuilder<T> {
    private HashMap<String, Class<?>> types = new HashMap();
    private HashMap<String, String> rangeIndextypes = new HashMap();
    private Class<?> clazz;
    private String classWrapper;
    private boolean wrapQueries = false;

    public PojoQueryBuilderImpl(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        this.clazz = clazz;
        this.classWrapper = clazz.getName();
    }

    public PojoQueryBuilderImpl(Class<T> clazz, boolean wrapQueries) {
        this(clazz);
        this.wrapQueries = wrapQueries;
    }

    private StructuredQueryBuilder.PathIndex pojoPropertyPath(String pojoProperty) {
        return this.pathIndex(this.classWrapper + "/" + pojoProperty);
    }

    @Override
    public StructuredQueryDefinition containerQuery(String pojoProperty, StructuredQueryDefinition query) {
        if (this.wrapQueries) {
            return super.containerQuery(this.jsonProperty(this.classWrapper), super.containerQuery(this.jsonProperty(pojoProperty), query));
        }
        return super.containerQuery(this.jsonProperty(pojoProperty), query);
    }

    @Override
    public <C> PojoQueryBuilder<C> containerQueryBuilder(String pojoProperty, Class<C> clazz) {
        return new PojoQueryBuilderImpl(this.getType(pojoProperty), true);
    }

    @Override
    public StructuredQueryBuilder.GeospatialIndex geoPair(String latitudePropertyName, String longitudePropertyName) {
        return this.geoJSONPropertyPair(this.jsonProperty(this.classWrapper), this.jsonProperty(latitudePropertyName), this.jsonProperty(longitudePropertyName));
    }

    public StructuredQueryBuilder.GeospatialIndex geoProperty(String pojoProperty) {
        return this.geoJSONProperty(this.jsonProperty(pojoProperty));
    }

    @Override
    public StructuredQueryBuilder.GeospatialIndex geoPath(String pojoProperty) {
        return this.geoPath(this.pojoPropertyPath(pojoProperty));
    }

    @Override
    public StructuredQueryDefinition geospatial(StructuredQueryBuilder.GeospatialIndex index, String[] options, StructuredQueryBuilder.Region ... regions) {
        return super.geospatial(index, StructuredQueryBuilder.FragmentScope.DOCUMENTS, options, regions);
    }

    @Override
    public StructuredQueryDefinition range(String pojoProperty, PojoQueryBuilder.Operator operator, Object ... values) {
        return this.range((StructuredQueryBuilder.RangeIndex)this.pojoPropertyPath(pojoProperty), this.getRangeIndexType(pojoProperty), this.convertOperator(operator), values);
    }

    @Override
    public StructuredQueryDefinition range(String pojoProperty, String[] options, PojoQueryBuilder.Operator operator, Object ... values) {
        return this.range((StructuredQueryBuilder.RangeIndex)this.pojoPropertyPath(pojoProperty), this.getRangeIndexType(pojoProperty), options, this.convertOperator(operator), values);
    }

    @Override
    public StructuredQueryDefinition value(String pojoProperty, String ... values) {
        if (this.wrapQueries) {
            return super.containerQuery(this.jsonProperty(this.classWrapper), this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), values));
        }
        return this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), values);
    }

    @Override
    public StructuredQueryDefinition value(String pojoProperty, Boolean value) {
        if (this.wrapQueries) {
            return super.containerQuery(this.jsonProperty(this.classWrapper), this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), value));
        }
        return this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), value);
    }

    @Override
    public StructuredQueryDefinition value(String pojoProperty, Number ... values) {
        if (this.wrapQueries) {
            return super.containerQuery(this.jsonProperty(this.classWrapper), this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), values));
        }
        return this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), values);
    }

    @Override
    public StructuredQueryDefinition value(String pojoProperty, String[] options, double weight, String ... values) {
        if (this.wrapQueries) {
            return super.containerQuery(this.jsonProperty(this.classWrapper), this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), null, options, weight, values));
        }
        return this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), null, options, weight, values);
    }

    @Override
    public StructuredQueryDefinition value(String pojoProperty, String[] options, double weight, Boolean value) {
        if (this.wrapQueries) {
            return super.containerQuery(this.jsonProperty(this.classWrapper), this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), null, options, weight, value));
        }
        return this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), null, options, weight, value);
    }

    @Override
    public StructuredQueryDefinition value(String pojoProperty, String[] options, double weight, Number ... values) {
        if (this.wrapQueries) {
            return super.containerQuery(this.jsonProperty(this.classWrapper), this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), null, options, weight, values));
        }
        return this.value((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), null, options, weight, values);
    }

    @Override
    public StructuredQueryDefinition word(String pojoProperty, String ... words) {
        if (this.wrapQueries) {
            return super.containerQuery(this.jsonProperty(this.classWrapper), super.word((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), words));
        }
        return super.word((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), words);
    }

    @Override
    public StructuredQueryDefinition word(String pojoProperty, String[] options, double weight, String ... words) {
        if (this.wrapQueries) {
            return super.containerQuery(this.jsonProperty(this.classWrapper), super.word((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), null, options, weight, words));
        }
        return super.word((StructuredQueryBuilder.TextIndex)this.jsonProperty(pojoProperty), null, options, weight, words);
    }

    private StructuredQueryBuilder.Operator convertOperator(PojoQueryBuilder.Operator operator) {
        switch (operator) {
            case LT: {
                return StructuredQueryBuilder.Operator.LT;
            }
            case LE: {
                return StructuredQueryBuilder.Operator.LE;
            }
            case GT: {
                return StructuredQueryBuilder.Operator.GT;
            }
            case GE: {
                return StructuredQueryBuilder.Operator.GE;
            }
            case EQ: {
                return StructuredQueryBuilder.Operator.EQ;
            }
            case NE: {
                return StructuredQueryBuilder.Operator.NE;
            }
        }
        throw new IllegalStateException("Unsupported Operator: " + (Object)((Object)operator));
    }

    @Override
    public StructuredQueryBuilder.TermQuery term(String ... terms) {
        return new PojoTermQuery(this.wrapQueries, null, terms);
    }

    @Override
    public StructuredQueryBuilder.TermQuery term(double weight, String ... terms) {
        return new PojoTermQuery(this.wrapQueries, weight, terms);
    }

    @Override
    public PojoQueryDefinition filteredQuery(StructuredQueryDefinition query) {
        CombinedQueryBuilderImpl cqb = new CombinedQueryBuilderImpl();
        StringHandle options = new StringHandle("<options><search-option>filtered</search-option></options>").withFormat(Format.XML);
        return cqb.combine(query, (QueryOptionsWriteHandle)options);
    }

    public String getRangeIndexType(String propertyName) {
        String type = this.rangeIndextypes.get(propertyName);
        if (type == null) {
            Class<?> propertyClass = this.getType(propertyName);
            if (String.class.isAssignableFrom(propertyClass)) {
                type = "xs:string";
            } else if (Integer.TYPE.equals(propertyClass)) {
                type = "xs:int";
            } else if (Integer.class.isAssignableFrom(propertyClass)) {
                type = "xs:int";
            } else if (Long.TYPE.equals(propertyClass)) {
                type = "xs:long";
            } else if (Long.class.isAssignableFrom(propertyClass)) {
                type = "xs:long";
            } else if (Float.TYPE.equals(propertyClass)) {
                type = "xs:float";
            } else if (Float.class.isAssignableFrom(propertyClass)) {
                type = "xs:float";
            } else if (Double.TYPE.equals(propertyClass)) {
                type = "xs:double";
            } else if (Double.class.isAssignableFrom(propertyClass)) {
                type = "xs:double";
            } else if (Number.class.isAssignableFrom(propertyClass)) {
                type = "xs:decimal";
            } else if (Date.class.isAssignableFrom(propertyClass)) {
                type = "xs:dateTime";
            }
            if (type == null) {
                throw new IllegalArgumentException("Property " + propertyName + " is not a native Java type");
            }
            this.rangeIndextypes.put(propertyName, type);
        }
        return type;
    }

    public Class<?> getType(String propertyName) {
        Class<?> propertyClass = this.types.get(propertyName);
        if (propertyClass == null) {
            String initCapPojoProperty = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            try {
                propertyClass = this.clazz.getField(propertyName).getType();
            }
            catch (NoSuchFieldException e) {
                Method getMethod = null;
                try {
                    getMethod = this.clazz.getMethod("get" + initCapPojoProperty, new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        getMethod = this.clazz.getMethod("is" + initCapPojoProperty, new Class[0]);
                        if (!Boolean.class.isAssignableFrom(getMethod.getReturnType())) {
                            getMethod = null;
                        }
                    }
                    catch (NoSuchMethodException e3) {
                        // empty catch block
                    }
                }
                if (getMethod != null) {
                    if (Modifier.isStatic(getMethod.getModifiers())) {
                        throw new IllegalArgumentException("get" + initCapPojoProperty + " cannot be static");
                    }
                    propertyClass = getMethod.getReturnType();
                    if (propertyClass == Void.TYPE) {
                        throw new IllegalArgumentException("get" + initCapPojoProperty + " must not have return type void");
                    }
                }
                String setMethodName = "set" + initCapPojoProperty;
                for (Method method : this.clazz.getMethods()) {
                    Class<?>[] parameters;
                    if (!setMethodName.equals(method.getName()) || (parameters = method.getParameterTypes()) == null || parameters.length != 1) continue;
                    propertyClass = parameters[0];
                    break;
                }
            }
            if (propertyClass == null) {
                throw new IllegalArgumentException("property " + propertyName + " not found, get" + initCapPojoProperty + " not found, and set" + initCapPojoProperty + " not found in class " + this.classWrapper);
            }
            this.types.put(propertyName, propertyClass);
        }
        return propertyClass;
    }

    public class PojoTermQuery
    extends StructuredQueryBuilder.TermQuery {
        private StructuredQueryBuilder.AbstractStructuredQuery query;

        public PojoTermQuery(boolean wrapQueries, Double weight, String ... terms) {
            super(PojoQueryBuilderImpl.this, weight, terms);
            StructuredQueryBuilder.TermQuery termQuery = new StructuredQueryBuilder.TermQuery(PojoQueryBuilderImpl.this, weight, terms);
            this.query = wrapQueries ? (StructuredQueryBuilder.AbstractStructuredQuery)PojoQueryBuilderImpl.this.containerQuery(PojoQueryBuilderImpl.this.jsonProperty(PojoQueryBuilderImpl.this.classWrapper), (StructuredQueryDefinition)termQuery) : termQuery;
        }

        @Override
        public void innerSerialize(XMLStreamWriter serializer) throws Exception {
            this.query.innerSerialize(serializer);
        }
    }
}

