/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.alerting;

import com.marklogic.client.MarkLogicBindingException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.ClientPropertiesImpl;
import com.marklogic.client.impl.DOMWriter;
import com.marklogic.client.impl.HandleAccessor;
import com.marklogic.client.impl.Utilities;
import com.marklogic.client.impl.ValueConverter;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.RuleReadHandle;
import com.marklogic.client.io.marker.RuleWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import com.marklogic.client.util.NameMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuleDefinition
extends BaseHandle<InputStream, OutputStreamSender>
implements OutputStreamSender,
RuleReadHandle,
RuleWriteHandle {
    private static final Logger logger = LoggerFactory.getLogger(RuleDefinition.class);
    private static XMLOutputFactory factory = XMLOutputFactory.newFactory();
    private ValueSerializer valueSerializer;
    private String name;
    private String description;
    private List<XMLEvent> queryPayload;
    private RuleMetadata metadata;

    public RuleDefinition(String name, String description) {
        this();
        this.setName(name);
        this.setDescription(description);
    }

    public RuleDefinition() {
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        this.metadata = new RuleMetadataImpl();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void importQueryDefinition(XMLWriteHandle queryDef) {
        List<XMLEvent> importedList = Utilities.importFromHandle(queryDef);
        XMLEvent firstEvent = importedList.get(0);
        if (firstEvent.getEventType() == 1) {
            StartElement startElement = firstEvent.asStartElement();
            if (startElement.getName().getNamespaceURI() == "http://marklogic.com/appservices/search" && startElement.getName().getLocalPart().equals("query")) {
                ArrayList<XMLEvent> wrappedList = new ArrayList<XMLEvent>();
                XMLEventFactory eventFactory = XMLEventFactory.newInstance();
                StartElement startSearchElement = eventFactory.createStartElement("search", "http://marklogic.com/appservices/search", "search");
                EndElement endSearchElement = eventFactory.createEndElement("search", "http://marklogic.com/appservices/search", "search");
                wrappedList.add(startSearchElement);
                wrappedList.addAll(importedList);
                wrappedList.add(endSearchElement);
                this.queryPayload = wrappedList;
            } else {
                this.queryPayload = importedList;
            }
        } else {
            logger.warn("Expected imported XML to be an element, but it's not.");
            this.queryPayload = importedList;
        }
    }

    public <T extends XMLReadHandle> T exportQueryDefinition(T handle) {
        return Utilities.exportToHandle(this.queryPayload, handle);
    }

    public RuleMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(RuleMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        try {
            this.valueSerializer = null;
            XMLStreamWriter serializer = factory.createXMLStreamWriter(out, "UTF-8");
            serializer.setPrefix("rapi", "http://marklogic.com/rest-api");
            serializer.setPrefix("search", "http://marklogic.com/appservices/search");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.setPrefix("xs", "http://www.w3.org/2001/XMLSchema");
            serializer.writeStartDocument("utf-8", "1.0");
            serializer.writeStartElement("rapi", "rule", "http://marklogic.com/rest-api");
            serializer.writeStartElement("rapi", "name", "http://marklogic.com/rest-api");
            serializer.writeCharacters(this.getName());
            serializer.writeEndElement();
            serializer.writeStartElement("rapi", "description", "http://marklogic.com/rest-api");
            String description = this.getDescription();
            if (description != null) {
                serializer.writeCharacters(description);
            }
            serializer.writeEndElement();
            serializer.flush();
            XMLEventWriter eventWriter = factory.createXMLEventWriter(out);
            for (XMLEvent event : this.queryPayload) {
                eventWriter.add(event);
            }
            eventWriter.flush();
            out.flush();
            this.writeMetadataElement(serializer);
            serializer.writeEndElement();
            serializer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new MarkLogicIOException("Failed to serialize rule", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new MarkLogicIOException("Failed to serialize rule", e);
        }
        catch (TransformerException e) {
            throw new MarkLogicIOException("Failed to serialize rule", e);
        }
        finally {
            this.valueSerializer = null;
        }
    }

    private Element getChildByName(Element element, String ns, String localName) {
        NodeList nl = element.getElementsByTagNameNS(ns, localName);
        if (nl.getLength() == 1) {
            return (Element)nl.item(0);
        }
        throw new MarkLogicBindingException("Invalid rule - must have one element only named " + localName);
    }

    @Override
    protected void receiveContent(InputStream content) {
        DOMHandle handle = new DOMHandle();
        HandleAccessor.receiveContent(handle, content);
        Element ruleElement = handle.get().getDocumentElement();
        this.receiveElement(ruleElement);
    }

    void receiveElement(Element ruleElement) {
        Element nameElement = this.getChildByName(ruleElement, "http://marklogic.com/rest-api", "name");
        this.setName(nameElement.getTextContent());
        Element descElement = this.getChildByName(ruleElement, "http://marklogic.com/rest-api", "description");
        this.setDescription(descElement.getTextContent());
        Element searchElement = this.getChildByName(ruleElement, "http://marklogic.com/appservices/search", "search");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("version", "1.0");
            trans.setOutputProperty("encoding", "UTF-8");
            trans.setOutputProperty("indent", "no");
            trans.transform(new DOMSource(searchElement), new StreamResult(baos));
            this.importQueryDefinition(new BytesHandle(baos.toByteArray()).withFormat(Format.XML));
        }
        catch (TransformerConfigurationException e) {
            throw new MarkLogicIOException("Could not get query from rule payload");
        }
        catch (TransformerException e) {
            throw new MarkLogicIOException("Could not get query from rule payload");
        }
        this.receiveRuleMetadataImpl(ruleElement);
    }

    private void receiveRuleMetadataImpl(Element ruleElement) {
        RuleMetadata ruleMetadata = this.getMetadata();
        ruleMetadata.clear();
        Node metadataContainer = ruleElement.getElementsByTagNameNS("http://marklogic.com/rest-api", "rule-metadata").item(0);
        if (metadataContainer == null) {
            return;
        }
        NodeList metadataIn = metadataContainer.getChildNodes();
        for (int i = 0; i < metadataIn.getLength(); ++i) {
            String prefix;
            Node node = metadataIn.item(i);
            if (node.getNodeType() != 1) continue;
            Element metadataElement = (Element)node;
            QName metadataPropertyName = null;
            String namespaceURI = metadataElement.getNamespaceURI();
            metadataPropertyName = namespaceURI != null ? ((prefix = metadataElement.getPrefix()) != null ? new QName(namespaceURI, metadataElement.getLocalName(), prefix) : new QName(namespaceURI, metadataElement.getTagName())) : new QName(metadataElement.getTagName());
            if (!metadataElement.hasChildNodes()) {
                this.metadata.put(metadataPropertyName, (String)null);
                continue;
            }
            NodeList children = metadataElement.getChildNodes();
            boolean hasChildElements = false;
            int childCount = children.getLength();
            for (int j = 0; j < childCount; ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                hasChildElements = true;
                break;
            }
            if (hasChildElements) {
                this.metadata.put(metadataPropertyName, children);
                continue;
            }
            String value = metadataElement.getTextContent();
            if (metadataElement.hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) {
                String type = metadataElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                this.metadata.put(metadataPropertyName, ValueConverter.convertToJava(type, value));
                continue;
            }
            this.metadata.put(metadataPropertyName, value);
            this.metadata.put(metadataPropertyName, value);
        }
    }

    private void writeMetadataElement(XMLStreamWriter serializer) throws XMLStreamException, TransformerFactoryConfigurationError, TransformerException {
        serializer.writeStartElement("rapi", "rule-metadata", "http://marklogic.com/rest-api");
        serializer.writeNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        for (Map.Entry metadataProperty : this.getMetadata().entrySet()) {
            QName propertyName = (QName)metadataProperty.getKey();
            Object value = metadataProperty.getValue();
            boolean hasNodeValue = value instanceof NodeList;
            String namespaceURI = propertyName.getNamespaceURI();
            String prefix = null;
            String localPart = propertyName.getLocalPart();
            if (namespaceURI != null && namespaceURI.length() > 0) {
                if ("http://marklogic.com/rest-api".equals(namespaceURI)) continue;
                prefix = propertyName.getPrefix();
                serializer.writeStartElement(prefix, localPart, namespaceURI);
            } else {
                serializer.writeStartElement(localPart);
            }
            if (!hasNodeValue) {
                if (this.valueSerializer == null) {
                    this.valueSerializer = new ValueSerializer(serializer);
                }
                ValueConverter.convertFromJava(value, (ValueConverter.ValueProcessor)this.valueSerializer);
            } else {
                new DOMWriter(serializer).serializeNodeList((NodeList)value);
            }
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected OutputStreamSender sendContent() {
        return this;
    }

    private static class ValueSerializer
    implements ValueConverter.ValueProcessor {
        private XMLStreamWriter serializer;

        public ValueSerializer(XMLStreamWriter serializer) {
            this.serializer = serializer;
        }

        @Override
        public void process(Object original, String type, String value) {
            if (original == null) {
                return;
            }
            try {
                this.serializer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", type);
                this.serializer.writeCharacters(value);
            }
            catch (XMLStreamException e) {
                throw new MarkLogicIOException(e);
            }
        }
    }

    private static class RuleMetadataImpl
    extends ClientPropertiesImpl
    implements RuleMetadata {
        private RuleMetadataImpl() {
        }
    }

    public static interface RuleMetadata
    extends NameMap<Object> {
    }
}

