/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.OutputStreamSender;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.QuadsWriteHandle;
import com.marklogic.client.io.marker.SPARQLResultsReadHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.io.marker.TriplesWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringHandle
extends BaseHandle<byte[], OutputStreamSender>
implements OutputStreamSender,
BufferableHandle,
ContentHandle<String>,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
QuadsWriteHandle,
TriplesReadHandle,
TriplesWriteHandle,
SPARQLResultsReadHandle {
    private String content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{String.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return String.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                StringHandle handle = this.isHandled(type) ? new StringHandle() : null;
                return handle;
            }
        };
    }

    public StringHandle() {
        this.setResendable(true);
    }

    public StringHandle(String content) {
        this();
        this.set(content);
    }

    @Override
    public String get() {
        return this.content;
    }

    @Override
    public void set(String content) {
        this.content = content;
    }

    public StringHandle with(String content) {
        this.set(content);
        return this;
    }

    public StringHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public StringHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.content = buffer == null || buffer.length == 0 ? null : new String(buffer, Charset.forName("UTF-8"));
    }

    @Override
    public byte[] toBuffer() {
        if (this.content == null) {
            return null;
        }
        return this.content.getBytes(Charset.forName("UTF-8"));
    }

    public String toString() {
        return this.content;
    }

    @Override
    protected Class<byte[]> receiveAs() {
        return byte[].class;
    }

    @Override
    protected void receiveContent(byte[] content) {
        try {
            if (content == null) {
                this.content = null;
                return;
            }
            this.content = new String(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    protected OutputStreamSender sendContent() {
        if (this.content == null) {
            throw new IllegalStateException("No string to write");
        }
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        out.write(this.toBuffer());
    }
}

