/*
 * Decompiled with CFR 0.152.
 */
package com.matecoder.core.context;

import com.matecoder.core.context.IdentityContext;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JwtHelper {
    private static final byte[] DEFAULT_SIGN_KEY_BYTES = "www.matecoder.com##www.somta.net".getBytes(StandardCharsets.UTF_8);
    private static final Integer DEFAULT_EXPIRE_HOUR = 2;
    private static final JWSAlgorithm JWT_ALGORITHM = JWSAlgorithm.HS256;

    public static String generateToken(String issuer, Map<String, Object> payload) {
        return JwtHelper.generateToken(issuer, payload, null, DEFAULT_EXPIRE_HOUR);
    }

    public static String generateToken(String issuer, Map<String, Object> payload, String signKeyStr) {
        return JwtHelper.generateToken(issuer, payload, signKeyStr, DEFAULT_EXPIRE_HOUR);
    }

    public static String generateToken(String issuer, Map<String, Object> payload, String signKeyStr, Integer expireHour) {
        try {
            JWSHeader jwsHeader = new JWSHeader.Builder(JWT_ALGORITHM).type(JOSEObjectType.JWT).build();
            Calendar instance = Calendar.getInstance();
            instance.add(10, expireHour);
            Date expireDate = instance.getTime();
            JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder().issuer(issuer).issueTime(new Date()).expirationTime(expireDate);
            if (payload != null && !payload.isEmpty()) {
                for (Map.Entry<String, Object> entry : payload.entrySet()) {
                    claimsBuilder.claim(entry.getKey(), entry.getValue());
                }
            }
            JWTClaimsSet claimsSet = claimsBuilder.build();
            SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
            MACSigner signer = new MACSigner(JwtHelper.getSignKeyBytes(signKeyStr));
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (JOSEException e) {
            throw new RuntimeException("\u751f\u6210JWT Token\u5931\u8d25", e);
        }
    }

    public static Boolean verifyExpired(String token, String signKeyStr) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return true;
        }
        try {
            JWTClaimsSet claimsSet = JwtHelper.getJWTClaimsSet(token, signKeyStr);
            return claimsSet.getExpirationTime().before(new Date());
        }
        catch (Exception e) {
            return true;
        }
    }

    public static IdentityContext parseToken(String token, String signKeyStr) {
        try {
            JWTClaimsSet claimsSet = JwtHelper.getJWTClaimsSet(token, signKeyStr);
            if (claimsSet == null) {
                return null;
            }
            Long userId = Long.valueOf(String.valueOf(claimsSet.getClaim("userId")));
            Long tenantId = Long.valueOf(String.valueOf(claimsSet.getClaim("tenantId")));
            Map extend = (Map)claimsSet.getClaim("extend");
            return new IdentityContext(userId, tenantId, extend);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790JWT Token\u5931\u8d25", e);
        }
    }

    private static JWTClaimsSet getJWTClaimsSet(String token, String signKeyStr) throws Exception {
        MACVerifier verifier;
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        if (!signedJWT.verify((JWSVerifier)(verifier = new MACVerifier(JwtHelper.getSignKeyBytes(signKeyStr))))) {
            throw new JOSEException("JWT Token\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        if (!JWT_ALGORITHM.equals((Object)signedJWT.getHeader().getAlgorithm())) {
            throw new JOSEException("JWT Token\u7b97\u6cd5\u4e0d\u5339\u914d\uff0c\u9884\u671fHS256");
        }
        return signedJWT.getJWTClaimsSet();
    }

    private static byte[] getSignKeyBytes(String signKeyStr) {
        if (StringUtils.isBlank((CharSequence)signKeyStr)) {
            return DEFAULT_SIGN_KEY_BYTES;
        }
        return signKeyStr.getBytes(StandardCharsets.UTF_8);
    }
}

