/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = UnsafeUtil.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.supportsUnsafeArrayOperations();
    private static final long ARRAY_BASE_OFFSET = UnsafeUtil.byteArrayBaseOffset();
    private static final long BUFFER_ADDRESS_OFFSET = UnsafeUtil.fieldOffset(UnsafeUtil.field(Buffer.class, "address"));

    private UnsafeUtil() {
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    static Object allocateInstance(Class<?> clazz) {
        try {
            return UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static long getArrayBaseOffset() {
        return ARRAY_BASE_OFFSET;
    }

    static byte getByte(Object target, long offset) {
        return UNSAFE.getByte(target, offset);
    }

    static void putByte(Object target, long offset, byte value) {
        UNSAFE.putByte(target, offset, value);
    }

    static int getInt(Object target, long offset) {
        return UNSAFE.getInt(target, offset);
    }

    static void putInt(Object target, long offset, int value) {
        UNSAFE.putInt(target, offset, value);
    }

    static long getLong(Object target, long offset) {
        return UNSAFE.getLong(target, offset);
    }

    static void putLong(Object target, long offset, long value) {
        UNSAFE.putLong(target, offset, value);
    }

    static boolean getBoolean(Object target, long offset) {
        return UNSAFE.getBoolean(target, offset);
    }

    static void putBoolean(Object target, long offset, boolean value) {
        UNSAFE.putBoolean(target, offset, value);
    }

    static float getFloat(Object target, long offset) {
        return UNSAFE.getFloat(target, offset);
    }

    static void putFloat(Object target, long offset, float value) {
        UNSAFE.putFloat(target, offset, value);
    }

    static double getDouble(Object target, long offset) {
        return UNSAFE.getDouble(target, offset);
    }

    static void putDouble(Object target, long offset, double value) {
        UNSAFE.putDouble(target, offset, value);
    }

    static Object getObject(Object target, long offset) {
        return UNSAFE.getObject(target, offset);
    }

    static void putObject(Object target, long offset, Object value) {
        UNSAFE.putObject(target, offset, value);
    }

    static void copyMemory(Object src, long srcOffset, Object target, long targetOffset, long length) {
        UNSAFE.copyMemory(src, srcOffset, target, targetOffset, length);
    }

    static byte getByte(long address) {
        return UNSAFE.getByte(address);
    }

    static void putByte(long address, byte value) {
        UNSAFE.putByte(address, value);
    }

    static int getInt(long address) {
        return UNSAFE.getInt(address);
    }

    static void putInt(long address, int value) {
        UNSAFE.putInt(address, value);
    }

    static long getLong(long address) {
        return UNSAFE.getLong(address);
    }

    static void putLong(long address, long value) {
        UNSAFE.putLong(address, value);
    }

    static void copyMemory(long srcAddress, long targetAddress, long length) {
        UNSAFE.copyMemory(srcAddress, targetAddress, length);
    }

    static void setMemory(long address, long numBytes, byte value) {
        UNSAFE.setMemory(address, numBytes, value);
    }

    static long addressOffset(ByteBuffer buffer) {
        return UNSAFE.getLong(buffer, BUFFER_ADDRESS_OFFSET);
    }

    private static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> k = Unsafe.class;
                    for (Field f : k.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object x = f.get(null);
                        if (!k.isInstance(x)) continue;
                        return (Unsafe)k.cast(x);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unsafe;
    }

    private static boolean supportsUnsafeArrayOperations() {
        boolean supported = false;
        if (UNSAFE != null) {
            try {
                Class<?> clazz = UNSAFE.getClass();
                clazz.getMethod("objectFieldOffset", Field.class);
                clazz.getMethod("allocateInstance", Class.class);
                clazz.getMethod("arrayBaseOffset", Class.class);
                clazz.getMethod("getByte", Object.class, Long.TYPE);
                clazz.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
                clazz.getMethod("getBoolean", Object.class, Long.TYPE);
                clazz.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                clazz.getMethod("getInt", Object.class, Long.TYPE);
                clazz.getMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
                clazz.getMethod("getLong", Object.class, Long.TYPE);
                clazz.getMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
                clazz.getMethod("getFloat", Object.class, Long.TYPE);
                clazz.getMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
                clazz.getMethod("getDouble", Object.class, Long.TYPE);
                clazz.getMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
                clazz.getMethod("getObject", Object.class, Long.TYPE);
                clazz.getMethod("putObject", Object.class, Long.TYPE, Object.class);
                clazz.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                supported = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return supported;
    }

    private static boolean supportsUnsafeByteBufferOperations() {
        boolean supported = false;
        if (UNSAFE != null) {
            try {
                Class<?> clazz = UNSAFE.getClass();
                clazz.getMethod("objectFieldOffset", Field.class);
                clazz.getMethod("getLong", Object.class, Long.TYPE);
                clazz.getMethod("getByte", Long.TYPE);
                clazz.getMethod("putByte", Long.TYPE, Byte.TYPE);
                clazz.getMethod("getInt", Long.TYPE);
                clazz.getMethod("putInt", Long.TYPE, Integer.TYPE);
                clazz.getMethod("getLong", Long.TYPE);
                clazz.getMethod("putLong", Long.TYPE, Long.TYPE);
                clazz.getMethod("setMemory", Long.TYPE, Long.TYPE, Byte.TYPE);
                clazz.getMethod("copyMemory", Long.TYPE, Long.TYPE, Long.TYPE);
                supported = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return supported;
    }

    private static int byteArrayBaseOffset() {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? UNSAFE.arrayBaseOffset(byte[].class) : -1;
    }

    private static long fieldOffset(Field field) {
        return field == null || UNSAFE == null ? -1L : UNSAFE.objectFieldOffset(field);
    }

    private static Field field(Class<?> clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (Throwable t) {
            field = null;
        }
        return field;
    }
}

