/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public final class MWCustomSSLContext
extends SSLContext {
    private static final String[] tlsProtocols;
    private final String[] enabledProtocols;

    public static SSLContext getInstance(String protocol) throws NoSuchAlgorithmException {
        return MWCustomSSLContext.getInstance(new String[]{protocol});
    }

    public static SSLContext getInstance(String protocol, String protocol2) throws NoSuchAlgorithmException {
        return MWCustomSSLContext.getInstance(new String[]{protocol, protocol2});
    }

    public static SSLContext getInstance(String ... protocols) throws NoSuchAlgorithmException {
        if (protocols.length == 0) {
            protocols = tlsProtocols;
        }
        String defaultProtocol = protocols[0];
        return new MWCustomSSLContext(new MWCustomSSLContextSpi(SSLContext.getInstance(defaultProtocol), protocols), protocols);
    }

    private MWCustomSSLContext(MWCustomSSLContextSpi spi, String[] enabledProtocols) {
        super(spi, spi.getProvider(), spi.getProtocol());
        this.enabledProtocols = enabledProtocols;
    }

    static {
        try {
            SSLContext context = SSLContext.getInstance("TLSv1");
            context.init(null, null, null);
            SSLEngine engine = context.createSSLEngine();
            ArrayList<String> supportedProtocols = new ArrayList<String>();
            for (String protocol : engine.getSupportedProtocols()) {
                boolean ssl = protocol.toLowerCase().contains("ssl");
                if (ssl) continue;
                supportedProtocols.add(protocol);
            }
            String[] enabledProtocols = new String[supportedProtocols.size()];
            tlsProtocols = supportedProtocols.toArray(enabledProtocols);
        }
        catch (KeyManagementException ex) {
            Throwable cause = ex.getCause();
            throw (RuntimeException)cause;
        }
        catch (NoSuchAlgorithmException ex) {
            Throwable cause = ex.getCause();
            throw (RuntimeException)cause;
        }
    }

    private static final class MWCustomSSLContextSpi
    extends SSLContextSpi {
        private final SSLContext fSSLContext;
        private SSLSocketFactory fSSLSocketFactory = null;
        private SSLServerSocketFactory fSSLServerSocketFactory = null;
        private final String[] enabledProtocols;

        MWCustomSSLContextSpi(SSLContext sslContext, String[] enabledProtocols) {
            this.fSSLContext = sslContext;
            this.enabledProtocols = enabledProtocols;
        }

        @Override
        public SSLEngine engineCreateSSLEngine() {
            SSLEngine engine = this.fSSLContext.createSSLEngine();
            engine.setEnabledProtocols(this.enabledProtocols);
            return engine;
        }

        @Override
        public SSLEngine engineCreateSSLEngine(String host, int port) {
            SSLEngine engine = this.fSSLContext.createSSLEngine(host, port);
            engine.setEnabledProtocols(this.enabledProtocols);
            return engine;
        }

        @Override
        public SSLSessionContext engineGetClientSessionContext() {
            return this.fSSLContext.getClientSessionContext();
        }

        @Override
        public SSLParameters engineGetDefaultSSLParameters() {
            return this.fSSLContext.getDefaultSSLParameters();
        }

        @Override
        public SSLSessionContext engineGetServerSessionContext() {
            return this.fSSLContext.getServerSessionContext();
        }

        @Override
        public synchronized SSLServerSocketFactory engineGetServerSocketFactory() {
            if (this.fSSLServerSocketFactory == null) {
                this.fSSLServerSocketFactory = new MWCustomSSLServerSocketFactory(this.fSSLContext);
            }
            return this.fSSLServerSocketFactory;
        }

        @Override
        public synchronized SSLSocketFactory engineGetSocketFactory() {
            if (this.fSSLSocketFactory == null) {
                this.fSSLSocketFactory = new MWCustomSSLSocketFactory(this.fSSLContext, this.enabledProtocols);
            }
            return this.fSSLSocketFactory;
        }

        @Override
        public SSLParameters engineGetSupportedSSLParameters() {
            return this.fSSLContext.getSupportedSSLParameters();
        }

        @Override
        public synchronized void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
            this.fSSLContext.init(km, tm, sr);
        }

        private Provider getProvider() {
            return this.fSSLContext.getProvider();
        }

        private String getProtocol() {
            return this.fSSLContext.getProtocol();
        }

        private final class MWCustomSSLServerSocketFactory
        extends SSLServerSocketFactory {
            private final SSLServerSocketFactory fSSLServerSocketFactory;

            MWCustomSSLServerSocketFactory(SSLContext sslContext) {
                this.fSSLServerSocketFactory = sslContext.getServerSocketFactory();
            }

            @Override
            public ServerSocket createServerSocket() throws IOException {
                return this.restrictProtocols(this.fSSLServerSocketFactory.createServerSocket());
            }

            @Override
            public ServerSocket createServerSocket(int port) throws IOException {
                return this.restrictProtocols(this.fSSLServerSocketFactory.createServerSocket(port));
            }

            @Override
            public ServerSocket createServerSocket(int port, int backlog) throws IOException {
                return this.restrictProtocols(this.fSSLServerSocketFactory.createServerSocket(port, backlog));
            }

            @Override
            public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
                return this.restrictProtocols(this.fSSLServerSocketFactory.createServerSocket(port, backlog, ifAddress));
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return this.fSSLServerSocketFactory.getDefaultCipherSuites();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return this.fSSLServerSocketFactory.getSupportedCipherSuites();
            }

            private SSLServerSocket restrictProtocols(ServerSocket serverSocket) {
                assert (serverSocket instanceof SSLServerSocket) : "An SSLServerSocketFactory has made a ServerSocket that is not an SSLServerSocket";
                SSLServerSocket sslSocket = (SSLServerSocket)serverSocket;
                sslSocket.setEnabledProtocols(MWCustomSSLContextSpi.this.enabledProtocols);
                return sslSocket;
            }
        }

        private final class MWCustomSSLSocketFactory
        extends SSLSocketFactory {
            private final SSLSocketFactory fCustomSSLSocketFactory;
            private final String[] enabledProtocols;

            MWCustomSSLSocketFactory(SSLContext sslContext, String[] enabledProtocols) {
                this.fCustomSSLSocketFactory = sslContext.getSocketFactory();
                this.enabledProtocols = enabledProtocols;
            }

            @Override
            public Socket createSocket() throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket());
            }

            @Override
            public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(socket, host, port, autoClose));
            }

            @Override
            public Socket createSocket(InetAddress host, int port) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(host, port));
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(address, port, localAddress, localPort));
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(host, port));
            }

            @Override
            public Socket createSocket(String address, int port, InetAddress localAddress, int localPort) throws IOException {
                return this.restrictProtocols(this.fCustomSSLSocketFactory.createSocket(address, port, localAddress, localPort));
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return this.fCustomSSLSocketFactory.getDefaultCipherSuites();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return this.fCustomSSLSocketFactory.getSupportedCipherSuites();
            }

            private SSLSocket restrictProtocols(Socket socket) {
                assert (socket instanceof SSLSocket) : "An SSLSocketFactory has made a Socket that is not an SSLSocket";
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setEnabledProtocols(this.enabledProtocols);
                return sslSocket;
            }
        }
    }
}

