/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.client.config.RequestConfig;
import com.mathworks.apache.http.client.methods.HttpPost;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.client.utils.URIBuilder;
import com.mathworks.apache.http.entity.ByteArrayEntity;
import com.mathworks.apache.http.impl.client.BasicCookieStore;
import com.mathworks.apache.http.nio.client.HttpAsyncClient;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWHttpException;
import com.mathworks.mps.client.MWRequest;
import com.mathworks.mps.client.MWRequestListener;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWFevalHandler;
import com.mathworks.mps.client.internal.ResponseProducer;
import com.mathworks.mps.client.internal.async.HttpResponseCallback;
import com.mathworks.mps.client.internal.async.InstanceInfo;
import com.mathworks.mps.client.internal.async.InterruptedMWRequestState;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import com.mathworks.mps.client.internal.async.MWRequestInfo;
import com.mathworks.mps.client.internal.async.SendingMWRequestState;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class ApacheFevalHandler
implements MWFevalHandler {
    private final ApacheHttpClient httpClient;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public ApacheFevalHandler(ApacheHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public <T> MWRequest<T> processRequest(URL url, MATLABParams.MATLAB_Params mlParams, ResponseProducer<T> builder, MWRequestListener<T> callback) {
        MWHttpClient mwClient = this.httpClient.getMWClient();
        HttpPost httpPost = new HttpPost(url.toString());
        String serverURI = this.parseServerURI(url);
        MWRequestInfo<T> requestInfo = new MWRequestInfo<T>(builder, mwClient.getClientUUID(), url);
        MWRequestImpl<T> mwRequest = new MWRequestImpl<T>(mwClient, callback, requestInfo, this);
        mwRequest.httpPost = httpPost;
        this.httpClient.pendingRequests.put(mwRequest.getTempId(), mwRequest);
        mwRequest.updateStateAndNotify(new SendingMWRequestState<T>(mlParams.toByteArray(), url, requestInfo));
        String cookieSpec = !mwClient.getConfig().isCookieEnabled() ? "ignoreCookies" : "default";
        this.LOG.trace("Setting cookie spec : {}", (Object)cookieSpec);
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setCookieStore(new BasicCookieStore());
        httpContext.setRequestConfig(RequestConfig.custom().setCookieSpec(cookieSpec).build());
        this.httpClient.executePost(httpPost, mlParams, httpContext, new HttpResponseCallback<T>(serverURI, mwRequest, this.httpClient, httpContext));
        return mwRequest;
    }

    private String parseServerURI(URL functionURL) {
        URIBuilder serverURI = new URIBuilder();
        serverURI.setScheme(functionURL.getProtocol());
        serverURI.setHost(functionURL.getHost());
        serverURI.setPort(functionURL.getPort());
        return serverURI.toString();
    }

    @Override
    public MATLABResult.MATLAB_Result processRequest(URL url, MATLABParams.MATLAB_Params mlParams) throws Throwable {
        HttpPost postReq = new HttpPost(url.toString());
        postReq.addHeader("Content-Type", "application/x-google-protobuf");
        postReq.setEntity(new ByteArrayEntity(mlParams.toByteArray()));
        HttpAsyncClient asyncClient = this.httpClient.getHttpClientAsync();
        this.LOG.info("MATLAB execution request: {}", (Object)url);
        Future<HttpResponse> future = asyncClient.execute(postReq, null);
        try {
            HttpResponse response = future.get();
            int respCode = response.getStatusLine().getStatusCode();
            if (respCode == 200) {
                return this.httpClient.parseMATLABResult(response);
            }
            throw new MWHttpException(respCode, response.getStatusLine().getReasonPhrase());
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
    }

    @Override
    public void close() {
        this.LOG.trace("Closing Apache HTTP client");
        this.httpClient.close();
    }

    @Override
    public boolean isClosed() {
        return this.httpClient.isClosed();
    }

    public ApacheHttpClient getApacheHttpClient() {
        return this.httpClient;
    }

    @Override
    public void abort() {
        this.LOG.trace("Aborting all pending requests. Number of requests not acknowledged by the server: {}", (Object)this.httpClient.pendingRequests.size());
        for (MWRequestImpl request : this.httpClient.pendingRequests.values()) {
            this.LOG.trace("Aborting request: {}", (Object)request.getClientRequestInfo().getSrcRequestURL());
            request.abort();
        }
        this.httpClient.pendingRequests.clear();
        this.LOG.trace("Aborting all update notification loops. Number of server instances: {}", (Object)this.httpClient.instances.size());
        for (InstanceInfo instance : this.httpClient.instances.values()) {
            instance.httpGet.abort();
            String sessionID = instance.getSessionId();
            if (this.httpClient.requestsCreated.containsKey(sessionID)) {
                for (MWRequestImpl request : this.httpClient.requestsCreated.get(sessionID).values()) {
                    request.updateStateAndNotify(new InterruptedMWRequestState());
                }
                this.httpClient.requestsCreated.get(sessionID).clear();
            }
            instance.getWaitNotifier().cancel();
        }
        this.httpClient.close();
    }
}

