/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.apache.http.client.utils.URIBuilder;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWInvokable;
import com.mathworks.mps.client.MWInvokeRequest;
import com.mathworks.mps.client.MWMarshalingRules;
import com.mathworks.mps.client.MWRequest;
import com.mathworks.mps.client.MWRequestListener;
import com.mathworks.mps.client.internal.ApacheFevalHandler;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import com.mathworks.mps.client.internal.MWClientUsageLock;
import com.mathworks.mps.client.internal.MWFevalHandler;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import com.mathworks.mps.client.internal.ResponseProducer;
import com.mathworks.mps.client.internal.async.FailedMWRequestState;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import java.net.URL;
import org.slf4j.Logger;

public class ComponentProxy
implements MWInvokable {
    private final MWFevalHandler fevalHandler;
    private final URL componentURL;
    private final MWAttributesContainer attributesContainer;
    private final MWHttpClient mwClient;
    private final MWClientUsageLock mwClientUsageLock;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public ComponentProxy(MWFevalHandler httpHandler, URL url, MWMarshalingRules marshalingRules, MWClientUsageLock clientUsageLock, MWHttpClient httpClient) {
        this.fevalHandler = httpHandler;
        this.componentURL = url;
        this.attributesContainer = new MWAttributesContainer(marshalingRules);
        this.mwClient = httpClient;
        this.mwClientUsageLock = clientUsageLock;
        this.LOG.debug("Component proxy initialized for component: {}", (Object)this.componentURL);
    }

    @Override
    public <T> T invoke(String functionName, int nargout, Class<T> targetType, Object ... inputs) throws Throwable {
        return this.processRequest(functionName, nargout, targetType, true, inputs);
    }

    @Override
    public <T> T invoke(String functionName, Class<T> targetType, Object ... inputs) throws Throwable {
        return this.processRequest(functionName, 1, targetType, false, inputs);
    }

    @Override
    public void invokeVoid(String functionName, Object ... inputs) throws Throwable {
        this.processRequest(functionName, 0, Void.TYPE, false, inputs);
    }

    @Override
    public <T> MWRequest<T> invokeAsync(MWInvokeRequest<T> invokeRequest, MWRequestListener<T> callback) {
        if (!this.mwClient.getConfig().isInterruptible()) {
            throw new RuntimeException("A non-interruptible client cannot be used to invoke methods asynchronously");
        }
        boolean hasNargout = false;
        int nargout = invokeRequest.getNargout();
        String functionName = invokeRequest.getMLFunction();
        Class<T> targetType = invokeRequest.getTargetType();
        Object[] inputs = invokeRequest.getInputParams();
        if (nargout > 1) {
            hasNargout = true;
        }
        return this.processRequestAsync(functionName, nargout, targetType, callback, hasNargout, inputs);
    }

    private <T> T processRequest(String functionName, int nargout, Class<T> targetType, boolean hasNargout, Object ... inputs) throws Throwable {
        this.mwClientUsageLock.usageEnter("MWHttpClient that provided the proxy object has already been closed");
        this.LOG.info("Invoking function (sync): {}", (Object)functionName);
        try {
            if (nargout > 1 && targetType != Object[].class) {
                throw new IllegalArgumentException("targetType must be Object[] if nargout value is greater than 1");
            }
            MATLABParams.MATLAB_Params mlParams = MWInvocationHandlerUtils.createMATLABParams(nargout, inputs, this.attributesContainer);
            MATLABResult.MATLAB_Result mlResult = this.fevalHandler.processRequest(new URL(this.componentURL.toString() + "/" + functionName), mlParams);
            ResponseProducer<T> builder = new ResponseProducer<T>(nargout, targetType, this.attributesContainer, functionName, hasNargout);
            builder.checkMLResultForErrors(mlResult);
            Object object = builder.createMATLABResponse(mlResult);
            return (T)object;
        }
        finally {
            this.mwClientUsageLock.usageExit();
        }
    }

    private <T> MWRequest<T> processRequestAsync(String functionName, int nargout, Class<T> targetType, MWRequestListener<T> callback, boolean hasNargout, Object ... inputs) {
        this.mwClientUsageLock.usageEnter("MWHttpClient that provided the proxy object has already been closed");
        try {
            if (nargout > 1 && targetType != Object[].class) {
                throw new IllegalArgumentException("targetType must be Object[] if nargout value is greater than 1");
            }
            if (nargout == 0 && targetType != Void.TYPE && targetType != Void.class) {
                throw new IllegalArgumentException("targetType must be void if nargout value is equal to 0");
            }
            if ((targetType == Void.TYPE || targetType == Void.class) && nargout != 0) {
                throw new IllegalArgumentException("targetType must be void if nargout value is equal to 0");
            }
            URIBuilder uri = new URIBuilder(this.componentURL.toString() + "/" + functionName);
            uri.addParameter("mode", "async");
            uri.addParameter("client", this.mwClient.getClientUUID().toString());
            MATLABParams.MATLAB_Params mlParams = MWInvocationHandlerUtils.createMATLABParams(nargout, inputs, this.attributesContainer);
            ResponseProducer<T> builder = new ResponseProducer<T>(nargout, targetType, this.attributesContainer, functionName, hasNargout);
            return this.fevalHandler.processRequest(new URL(uri.toString()), mlParams, builder, callback);
        }
        catch (Exception ex) {
            this.mwClientUsageLock.usageExit();
            MWRequestImpl mwRequest = new MWRequestImpl(this.mwClient, callback, null, (ApacheFevalHandler)this.fevalHandler);
            mwRequest.updateStateAndNotify(new FailedMWRequestState(ex));
            return mwRequest;
        }
    }
}

