/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.google.protobuf.ProtocolStringList;
import com.mathworks.mps.client.internal.ArrayNumericCoercionEnabler;
import com.mathworks.mps.client.internal.ArrayUtils;
import com.mathworks.mps.client.internal.Curler;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import com.mathworks.mps.client.internal.MWStructInfo;
import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaDataExtractor {
    private static Map<Class, Method> targetTypeToScalarCoercionMethod;
    private static Map<Class, Method> targetTypeToArrayCoercionMethod;
    private static Map<MATLABArray.MATLAB_Array.MWType, List> directlyConvertibleTypesMap;
    private static Map<MATLABArray.MATLAB_Array.MWType, List> scalarCoercibleNumericTypesMap;
    private static Map<Class, Class> primitiveToArrayType;
    private static final String COMPLEX_DATA_ERR_MSG = "Deployed MATLAB function returned complex data. Complex data is not supported.";
    private final MWAttributesContainer mwAttributesContainer;

    public JavaDataExtractor(MWAttributesContainer mwAttributesContainer) {
        this.mwAttributesContainer = mwAttributesContainer;
    }

    public Object toJavaType(MATLABArray.MATLAB_Array mlArray, Class targetType) {
        return this.getmlArray(mlArray, targetType, Method.class);
    }

    private Object getmlArray(MATLABArray.MATLAB_Array mlArray, Class targetType, Class parentElementClass) {
        Map<MWStructInfo, MWStructToBeanFactory> structToBeanFactoryCache = this.mwAttributesContainer.getChildrenStructsForParentMLOutput(parentElementClass);
        MATLABArray.MATLAB_Array.MWType mwType = mlArray.getType();
        switch (mwType) {
            case SPARSE: {
                throw new RuntimeException("Currently, MATLAB sparse data type is not supported");
            }
            case STRUCT: {
                return this.MATLABArrayToJavaStruct(mlArray, targetType, structToBeanFactoryCache);
            }
            case CELL: {
                return this.MATLABArrayToJavaCell(mlArray, targetType, structToBeanFactoryCache);
            }
        }
        return JavaDataExtractor.MATLABArrayToJavaPrimitives(mlArray, targetType, mwType);
    }

    private static String coersionFailureMsg(MATLABArray.MATLAB_Array.MWType srcType, List<Long> srcDims, Class targetType, int targetNumDims) {
        return "Data returned from MATLAB had dimensions : " + srcDims + " and type : " + srcType.toString().toLowerCase() + ".\nTarget Java type, " + targetType.getName() + ", has number of dimensions : " + targetNumDims + ".\nFailed to change the dimensions of data from MATLAB to match the number of dimensions of target Java type.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object MATLABArrayToJavaStruct(MATLABArray.MATLAB_Array mlArray, Class targetType, Map<MWStructInfo, MWStructToBeanFactory> structToBeanFactoryCache) {
        int[] dimArr;
        Object[] flattenedBean = this.convertStructToBeanArray(mlArray, structToBeanFactoryCache);
        ArrayList<Long> dimsList = new ArrayList<Long>(mlArray.getDimensionList());
        Class<?> srcEleType = flattenedBean.getClass().getComponentType();
        Class targetTypeScalar = ArrayUtils.getArrayElementType(targetType);
        int targetNumDims = ArrayUtils.getNumberOfDimensions(targetType);
        if (!targetTypeScalar.isAssignableFrom(srcEleType)) throw new RuntimeException("Deployed MATLAB function returned (" + srcEleType.getName() + "). Unable to assign MATLAB data type (" + srcEleType.getName() + ") to Java data type (" + targetTypeScalar.getName() + ")");
        if (dimsList.contains(0L)) {
            return null;
        }
        if (targetTypeScalar != Object.class) {
            if (!ArrayUtils.coerceDimsList(dimsList, targetNumDims)) {
                throw new RuntimeException(JavaDataExtractor.coersionFailureMsg(mlArray.getType(), mlArray.getDimensionList(), targetTypeScalar, targetNumDims));
            }
        } else {
            if (targetType != Object.class) throw new RuntimeException("A MATLAB array of type structure cannot be marshaled into an Object array with, " + targetNumDims + ", number of dimensions");
            ArrayUtils.coerceDimsList(dimsList, 0);
        }
        if ((dimArr = ArrayUtils.toIntArray(dimsList.toArray(new Long[dimsList.size()]))).length != 0) return Curler.curl(flattenedBean, dimArr);
        return flattenedBean[0];
    }

    public Object MATLABArrayToJavaCell(MATLABArray.MATLAB_Array mlArray, Class targetType, Map<MWStructInfo, MWStructToBeanFactory> structToBeanFactoryCache) {
        Class targetTypeScalar = ArrayUtils.getArrayElementType(targetType);
        ArrayList<Long> dimsList = new ArrayList<Long>(mlArray.getDimensionList());
        int targetNumDims = ArrayUtils.getNumberOfDimensions(targetType);
        if (targetTypeScalar == String.class) {
            if (dimsList.contains(0L)) {
                return null;
            }
            if (!ArrayUtils.coerceDimsList(dimsList, targetNumDims)) {
                throw new RuntimeException(JavaDataExtractor.coersionFailureMsg(mlArray.getType(), mlArray.getDimensionList(), String.class, targetNumDims));
            }
            int[] dimArr = ArrayUtils.toIntArray(dimsList.toArray(new Long[dimsList.size()]));
            return JavaDataExtractor.MATLABArrayToJavaCellStrings(mlArray, dimArr);
        }
        if (targetTypeScalar == Object.class) {
            if (dimsList.contains(0L)) {
                return null;
            }
            if (targetNumDims == 0) {
                targetNumDims = 1;
            }
            ArrayUtils.coerceDimsList(dimsList, targetNumDims);
            int[] dimArr = ArrayUtils.toIntArray(dimsList.toArray(new Long[dimsList.size()]));
            if (targetType == Object.class && JavaDataExtractor.isCellArrayOfOnlyStrings(mlArray)) {
                return JavaDataExtractor.MATLABArrayToJavaCellStrings(mlArray, dimArr);
            }
            return this.MATLABArrayToJavaCellObjects(mlArray, dimArr, structToBeanFactoryCache);
        }
        throw new RuntimeException("Deployed MATLAB function returned (cell). Unable to assign MATLAB data type (cell) to Java data type (" + targetType.getName() + ")");
    }

    private static boolean isCellArrayOfOnlyStrings(MATLABArray.MATLAB_Array mlArray) {
        List<MATLABArray.MATLAB_Array> data = mlArray.getExtension(MATLABArray.MATLAB_Array.cell).getElementsList();
        for (MATLABArray.MATLAB_Array ele : data) {
            if (ele.getType() == MATLABArray.MATLAB_Array.MWType.CHAR) continue;
            return false;
        }
        return true;
    }

    private static Object MATLABArrayToJavaCellStrings(MATLABArray.MATLAB_Array mlArray, int[] dimArr) {
        List<MATLABArray.MATLAB_Array> data = mlArray.getExtension(MATLABArray.MATLAB_Array.cell).getElementsList();
        String[] objData = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            MATLABArray.MATLAB_Array ele = data.get(i);
            MATLABArray.MATLAB_Array.MWType mwType = ele.getType();
            if (mwType == MATLABArray.MATLAB_Array.MWType.CHAR) {
                ArrayList<Long> eleDims = new ArrayList<Long>(ele.getDimensionList());
                if (eleDims.contains(0L)) {
                    objData[i] = "";
                    continue;
                }
                ArrayUtils.coerceDimsList(eleDims, 0);
                int[] eleDimsArr = ArrayUtils.toIntArray(eleDims.toArray(new Long[eleDims.size()]));
                objData[i] = (String)JavaDataExtractor.MATLABCharArrayToJava(ele, eleDimsArr, String.class);
                continue;
            }
            throw new RuntimeException("Expecting a cell array containing only strings.\nFound one of the elements in cell array of type :" + mwType.toString());
        }
        if (dimArr.length == 0) {
            return objData[0];
        }
        return Curler.curl(objData, dimArr);
    }

    private Object MATLABArrayToJavaCellObjects(MATLABArray.MATLAB_Array mlArray, int[] dimArr, Map<MWStructInfo, MWStructToBeanFactory> structToBeanFactoryCache) {
        List<MATLABArray.MATLAB_Array> data = mlArray.getExtension(MATLABArray.MATLAB_Array.cell).getElementsList();
        Object[] objData = new Object[data.size()];
        block4: for (int i = 0; i < data.size(); ++i) {
            MATLABArray.MATLAB_Array cellEle = data.get(i);
            MATLABArray.MATLAB_Array.MWType mwType = cellEle.getType();
            switch (mwType) {
                case STRUCT: {
                    objData[i] = this.MATLABArrayToJavaStruct(cellEle, Object.class, structToBeanFactoryCache);
                    continue block4;
                }
                case CELL: {
                    objData[i] = this.MATLABArrayToJavaCell(cellEle, Object.class, structToBeanFactoryCache);
                    continue block4;
                }
                default: {
                    objData[i] = this.toJavaType(cellEle, Object.class);
                }
            }
        }
        return Curler.curl(objData, dimArr);
    }

    public static Object MATLABArrayToJavaPrimitives(MATLABArray.MATLAB_Array mlArray, Class targetType, MATLABArray.MATLAB_Array.MWType mwType) {
        int[] dims;
        Object result = null;
        String mwTypeStr = mwType.toString().toLowerCase();
        ArrayList<Long> dimsList = new ArrayList<Long>(mlArray.getDimensionList());
        Class targetTypeScalar = ArrayUtils.getArrayElementType(targetType);
        int targetNumDims = ArrayUtils.getNumberOfDimensions(targetType);
        if (dimsList.contains(0L)) {
            if (targetType.isPrimitive()) {
                throw new RuntimeException("MATLAB returned data with dimensions : " + dimsList + ".\nThis is an empty MATLAB array since one of the dimensions is 0.\nEmpty MATLAB arrays are marshaled into Java as null.The scalar primitive target type, " + targetType.getName() + ", in Java cannot be assigned null.");
            }
            if (mwType == MATLABArray.MATLAB_Array.MWType.CHAR && targetType == String.class) {
                return "";
            }
            return null;
        }
        if (!JavaDataExtractor.isTargetTypeAssignableFromMATLABType(targetTypeScalar, mwType)) {
            throw new RuntimeException("Deployed MATLAB function returned (" + mwTypeStr.toLowerCase() + "). Unable to assign MATLAB data type (" + mwTypeStr.toLowerCase() + ") to Java data type (" + targetTypeScalar.getName() + ")");
        }
        if (targetTypeScalar != Object.class && targetTypeScalar != String.class) {
            if (!ArrayUtils.coerceDimsList(dimsList, targetNumDims)) {
                throw new RuntimeException(JavaDataExtractor.coersionFailureMsg(mwType, mlArray.getDimensionList(), targetTypeScalar, targetNumDims));
            }
        } else if (targetTypeScalar == Object.class || targetType == String.class) {
            ArrayUtils.coerceDimsList(dimsList, 0);
        } else {
            throw new RuntimeException("Received MATLAB array of type : " + mwTypeStr + ", with dimensions : " + dimsList + ".\nIt cannot be assigned to target of type : " + targetType.getName() + ", in Java.");
        }
        try {
            dims = ArrayUtils.toIntArray(dimsList.toArray(new Long[dimsList.size()]));
        }
        catch (BufferOverflowException ex) {
            throw new RuntimeException(ex);
        }
        switch (mwType) {
            case UINT8: {
                result = JavaDataExtractor.MATLABUint8ArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case INT8: {
                result = JavaDataExtractor.MATLABInt8ArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case UINT16: {
                result = JavaDataExtractor.MATLABUint16ArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case INT16: {
                result = JavaDataExtractor.MATLABInt16ArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case UINT32: {
                result = JavaDataExtractor.MATLABUint32ArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case INT32: {
                result = JavaDataExtractor.MATLABInt32ArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case UINT64: {
                result = JavaDataExtractor.MATLABUint64ArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case INT64: {
                result = JavaDataExtractor.MATLABInt64ArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case SINGLE: {
                result = JavaDataExtractor.MATLABSingleArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case DOUBLE: {
                result = JavaDataExtractor.MATLABDoubleArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case LOGICAL: {
                result = JavaDataExtractor.MATLABLogicalArrayToJava(mlArray, dims, targetType, targetTypeScalar, mwType);
                break;
            }
            case CHAR: {
                result = JavaDataExtractor.MATLABCharArrayToJava(mlArray, dims, targetType);
            }
        }
        if (targetTypeScalar == Object.class && targetNumDims > 0) {
            Object[] newResult = new Object[]{result};
            int[] targetDims = new int[targetNumDims];
            Arrays.fill(targetDims, 1);
            return Curler.curl(newResult, targetDims);
        }
        return result;
    }

    public static Object MATLABUint8ArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Uint8 uint8Ext = mlArr.getExtension(MATLABArray.MATLAB_Array.uint8);
        if (uint8Ext.hasImagElements()) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        byte[] data = uint8Ext.getElements().toByteArray();
        return JavaDataExtractor.byteArrayToTargetType(data, Byte.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABInt8ArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Int8 int8Ext = mlArr.getExtension(MATLABArray.MATLAB_Array.int8);
        if (int8Ext.hasImagElements()) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        byte[] data = int8Ext.getElements().toByteArray();
        return JavaDataExtractor.byteArrayToTargetType(data, Byte.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABUint16ArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Uint16 uint16Ext = mlArr.getExtension(MATLABArray.MATLAB_Array.uint16);
        if (uint16Ext.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Integer> data = uint16Ext.getElementsList();
        List<Short> shortData = ArrayUtils.convertToShortList(data);
        return JavaDataExtractor.toTargetType(shortData, Short.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABInt16ArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Int16 int16Ext = mlArr.getExtension(MATLABArray.MATLAB_Array.int16);
        if (int16Ext.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Integer> data = int16Ext.getElementsList();
        List<Short> shortData = ArrayUtils.convertToShortList(data);
        return JavaDataExtractor.toTargetType(shortData, Short.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABUint32ArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Uint32 uint32Ext = mlArr.getExtension(MATLABArray.MATLAB_Array.uint32);
        if (uint32Ext.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Integer> data = uint32Ext.getElementsList();
        return JavaDataExtractor.toTargetType(data, Integer.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABInt32ArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Int32 int32Ext = mlArr.getExtension(MATLABArray.MATLAB_Array.int32);
        if (int32Ext.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Integer> data = int32Ext.getElementsList();
        return JavaDataExtractor.toTargetType(data, Integer.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABUint64ArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Uint64 uint64Ext = mlArr.getExtension(MATLABArray.MATLAB_Array.uint64);
        if (uint64Ext.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Long> data = uint64Ext.getElementsList();
        return JavaDataExtractor.toTargetType(data, Long.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABInt64ArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Int64 int64Ext = mlArr.getExtension(MATLABArray.MATLAB_Array.int64);
        if (int64Ext.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Long> data = int64Ext.getElementsList();
        return JavaDataExtractor.toTargetType(data, Long.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABSingleArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Single singleExt = mlArr.getExtension(MATLABArray.MATLAB_Array.single);
        if (singleExt.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Float> data = singleExt.getElementsList();
        return JavaDataExtractor.toTargetType(data, Float.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABDoubleArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        MATLABArray.MATLAB_Array.Double doubleExt = mlArr.getExtension(MATLABArray.MATLAB_Array.mwdouble);
        if (doubleExt.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Double> data = doubleExt.getElementsList();
        return JavaDataExtractor.toTargetType(data, Double.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABLogicalArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        List<Boolean> data = mlArr.getExtension(MATLABArray.MATLAB_Array.logical).getElementsList();
        return JavaDataExtractor.toTargetType(data, Boolean.class, dimArr, targetType, targetTypeScalar, mwType);
    }

    public static Object MATLABCharArrayToJava(MATLABArray.MATLAB_Array mlArr, int[] dimArr, Class targetType) {
        Object result;
        List<Integer> data = mlArr.getExtension(MATLABArray.MATLAB_Array.mwchar).getElementsList();
        Integer[] boxedData = data.toArray(new Integer[data.size()]);
        char[] charData = ArrayUtils.toCharArray(boxedData);
        if (targetType == String.class) {
            if (dimArr.length > 1) {
                ArrayList<Integer> iList = new ArrayList<Integer>(dimArr.length);
                for (int i : dimArr) {
                    iList.add(i);
                }
                throw new RuntimeException("Failure to assign char array of size, " + iList + ", received from MATLAB to an instance of java.lang.String.");
            }
            result = new String(charData);
        } else {
            Class targetTypeScalar = ArrayUtils.getArrayElementType(targetType);
            if (dimArr.length == 0) {
                return Character.valueOf(charData[0]);
            }
            if (targetTypeScalar == Object.class && dimArr.length == 1) {
                return new String(charData);
            }
            result = targetTypeScalar == Character.class ? Curler.curl((Object[])ArrayUtils.toCharacterArray(boxedData), dimArr) : Curler.curl(charData, dimArr);
        }
        return result;
    }

    private Object[] convertStructToBeanArray(MATLABArray.MATLAB_Array mlArr, Map<MWStructInfo, MWStructToBeanFactory> structToBeanFactoryCache) {
        MATLABArray.MATLAB_Array.Struct struct = mlArr.getExtension(MATLABArray.MATLAB_Array.struct);
        ProtocolStringList fieldNames = struct.getFieldNamesList();
        MWStructToBeanFactory beanFactory = structToBeanFactoryCache.get(new MWStructInfo(fieldNames));
        if (beanFactory == null) {
            throw new RuntimeException("No user defined JAVA type available for a MATLAB structure with fields : " + fieldNames);
        }
        List<MATLABArray.MATLAB_Array> fieldVals = struct.getElementsList();
        int numFields = fieldNames.size();
        int numEle = numFields == 0 ? 0 : fieldVals.size() / numFields;
        Object[] flattenedBean = (Object[])Array.newInstance(beanFactory.getBeanType(), numEle);
        int k = 0;
        for (int i = 0; i < numEle; ++i) {
            Object[] beanArgs = new Object[numFields];
            for (int j = 0; j < numFields; ++j) {
                String fieldName = (String)fieldNames.get(j);
                MATLABArray.MATLAB_Array field = fieldVals.get(k++);
                try {
                    beanArgs[j] = this.getmlArray(field, beanFactory.getJavaClassForStructField(fieldName), beanFactory.getBeanType());
                    continue;
                }
                catch (Exception ex) {
                    String beanName = beanFactory.getBeanType().getName();
                    String fieldTypeName = beanFactory.getJavaClassForStructField(fieldName).getName();
                    String errMsg = "Trouble marshaling a MATLAB structure with fields : " + fieldNames + ",\ninto a user defined Java class : " + beanName + ".\nProperty, " + fieldName + ", of class, " + beanName + ", has a declared type of : " + fieldTypeName + ",\nbut was assigned a value of MATLAB type : " + field.getType().toString().toLowerCase() + ".\nPlease refer the javadoc for more information on automatic type conversion.";
                    throw new RuntimeException(errMsg, ex);
                }
            }
            flattenedBean[i] = beanFactory.newInstance(fieldNames, beanArgs);
        }
        return flattenedBean;
    }

    private static <T> Object toTargetType(List<T> data, Class<T> sourceType, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        if (dimArr.length == 0) {
            if (!JavaDataExtractor.canBeCoerced(targetTypeScalar, mwType)) {
                return data.get(0);
            }
            return JavaDataExtractor.convertScalarType(targetTypeScalar, data.get(0));
        }
        Object[] boxedData = ArrayUtils.convertToArray(data, sourceType);
        if (JavaDataExtractor.canBeCoerced(targetTypeScalar, mwType)) {
            Object primitiveData = JavaDataExtractor.convertArrayType(targetType, targetTypeScalar, boxedData, dimArr);
            return JavaDataExtractor.curlArray(primitiveData, targetTypeScalar, dimArr);
        }
        if (targetTypeScalar.equals(Object.class) || targetTypeScalar.isPrimitive()) {
            Class primitiveType = ArrayUtils.unBoxIfBoxedType(sourceType);
            Object primitiveData = ArrayUtils.toPrimitiveArray(boxedData, primitiveType);
            return JavaDataExtractor.curlArray(primitiveData, primitiveType, dimArr);
        }
        return Curler.curl(boxedData, dimArr);
    }

    private static Object byteArrayToTargetType(byte[] data, Class sourceType, int[] dimArr, Class targetType, Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        if (dimArr.length == 0) {
            if (!JavaDataExtractor.canBeCoerced(targetTypeScalar, mwType)) {
                return data[0];
            }
            return JavaDataExtractor.convertScalarType(targetTypeScalar, data[0]);
        }
        if (JavaDataExtractor.canBeCoerced(targetTypeScalar, mwType)) {
            Byte[] boxedData = ArrayUtils.toBoxedArray(data);
            Object primitiveData = JavaDataExtractor.convertArrayType(targetType, targetTypeScalar, boxedData, dimArr);
            return JavaDataExtractor.curlArray(primitiveData, targetTypeScalar, dimArr);
        }
        if (targetTypeScalar.equals(Object.class) || targetTypeScalar.isPrimitive()) {
            return Curler.curl(data, dimArr);
        }
        Object[] boxedData = ArrayUtils.toBoxedArray(data);
        return Curler.curl(boxedData, dimArr);
    }

    private static Object curlArray(Object primitiveData, Class targetTypeScalar, int[] dimArr) {
        try {
            Method miCurl = Curler.class.getMethod("curl", primitiveToArrayType.get(targetTypeScalar), int[].class);
            return miCurl.invoke(null, primitiveData, dimArr);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failure to coerce a MATLAB array to Java type :", ex);
        }
    }

    private static boolean isTargetTypeAssignableFromMATLABType(Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        return directlyConvertibleTypesMap.get(mwType).contains(targetTypeScalar) || scalarCoercibleNumericTypesMap.containsKey(mwType) && scalarCoercibleNumericTypesMap.get(mwType).contains(targetTypeScalar);
    }

    private static boolean canBeCoerced(Class targetTypeScalar, MATLABArray.MATLAB_Array.MWType mwType) {
        return scalarCoercibleNumericTypesMap.containsKey(mwType) && scalarCoercibleNumericTypesMap.get(mwType).contains(targetTypeScalar);
    }

    private static Object convertScalarType(Class targetTypeScalar, Object data) {
        try {
            return targetTypeToScalarCoercionMethod.get(targetTypeScalar).invoke(data, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to coerce a scalar MATLAB value to Java type : " + targetTypeScalar);
        }
    }

    private static Object convertArrayType(Class targetType, Class targetTypeScalar, Object boxedflatArray, int[] dimsArr) {
        try {
            return targetTypeToArrayCoercionMethod.get(targetTypeScalar).invoke(null, boxedflatArray);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to coerce a MATLAB array of Type to Java type : " + targetType, e);
        }
    }

    static {
        directlyConvertibleTypesMap = new HashMap<MATLABArray.MATLAB_Array.MWType, List>();
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT8, Arrays.asList(Object.class, Byte.TYPE, Byte.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT8, Arrays.asList(Object.class, Byte.TYPE, Byte.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT16, Arrays.asList(Object.class, Short.TYPE, Short.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT16, Arrays.asList(Object.class, Short.TYPE, Short.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT32, Arrays.asList(Object.class, Integer.TYPE, Integer.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT32, Arrays.asList(Object.class, Integer.TYPE, Integer.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT64, Arrays.asList(Object.class, Long.TYPE, Long.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT64, Arrays.asList(Object.class, Long.TYPE, Long.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.SINGLE, Arrays.asList(Object.class, Float.TYPE, Float.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.DOUBLE, Arrays.asList(Object.class, Double.TYPE, Double.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.LOGICAL, Arrays.asList(Object.class, Boolean.TYPE, Boolean.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.CHAR, Arrays.asList(Object.class, Character.TYPE, Character.class, String.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.CELL, Arrays.asList(Object.class, String.class));
        scalarCoercibleNumericTypesMap = new HashMap<MATLABArray.MATLAB_Array.MWType, List>();
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT8, Arrays.asList(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT8, Arrays.asList(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT16, Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT16, Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT32, Arrays.asList(Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT32, Arrays.asList(Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT64, Arrays.asList(Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT64, Arrays.asList(Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.SINGLE, Arrays.asList(Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.DOUBLE, Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE));
        targetTypeToScalarCoercionMethod = new HashMap<Class, Method>();
        try {
            targetTypeToScalarCoercionMethod.put(Byte.TYPE, Number.class.getMethod("byteValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Short.TYPE, Number.class.getMethod("shortValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Integer.TYPE, Number.class.getMethod("intValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Long.TYPE, Number.class.getMethod("longValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Float.TYPE, Number.class.getMethod("floatValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Double.TYPE, Number.class.getMethod("doubleValue", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        targetTypeToArrayCoercionMethod = new HashMap<Class, Method>();
        targetTypeToArrayCoercionMethod.put(Byte.TYPE, ArrayNumericCoercionEnabler.toByteArray);
        targetTypeToArrayCoercionMethod.put(Double.TYPE, ArrayNumericCoercionEnabler.toDoubleArray);
        targetTypeToArrayCoercionMethod.put(Float.TYPE, ArrayNumericCoercionEnabler.toFloatArray);
        targetTypeToArrayCoercionMethod.put(Integer.TYPE, ArrayNumericCoercionEnabler.toIntegerArray);
        targetTypeToArrayCoercionMethod.put(Long.TYPE, ArrayNumericCoercionEnabler.toLongArray);
        targetTypeToArrayCoercionMethod.put(Short.TYPE, ArrayNumericCoercionEnabler.toShortArray);
        primitiveToArrayType = new HashMap<Class, Class>();
        primitiveToArrayType.put(Byte.TYPE, byte[].class);
        primitiveToArrayType.put(Double.TYPE, double[].class);
        primitiveToArrayType.put(Float.TYPE, float[].class);
        primitiveToArrayType.put(Integer.TYPE, int[].class);
        primitiveToArrayType.put(Long.TYPE, long[].class);
        primitiveToArrayType.put(Short.TYPE, short[].class);
        primitiveToArrayType.put(Boolean.TYPE, boolean[].class);
    }
}

