/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.internal.ArrayUtils;
import com.mathworks.mps.client.internal.Flattener;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MATLABPrimitiveArrayBuilder;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MATLABArrayBuilder {
    private static final List<Class> flattenedDataClassTypes = new ArrayList<Class>();
    private final MWAttributesContainer mwAttributesContainer;

    public MATLABArrayBuilder(MWAttributesContainer mwAttributesContainer) {
        this.mwAttributesContainer = mwAttributesContainer;
    }

    public MATLABArray.MATLAB_Array arrayFromData(Object data) {
        return this.flattenAndIdentifyNextType(data, Method.class);
    }

    private MATLABArray.MATLAB_Array flattenAndIdentifyNextType(Object data, Class elementClass) {
        Map<Class, Map<String, Method>> beanToStructCache = this.mwAttributesContainer.getChildrenStructsForParentMLInput(elementClass);
        if (data == null) {
            return this.createEmptyMATLABArray();
        }
        MATLABArray.MATLAB_Array.Builder mwArray = MATLABArray.MATLAB_Array.newBuilder();
        Class<?> inputType = data.getClass();
        Object flattenedData = null;
        Method m = null;
        try {
            m = Flattener.class.getMethod("flatten", inputType);
            flattenedData = m.invoke(null, data);
        }
        catch (NoSuchMethodException ex) {
            try {
                flattenedData = Flattener.flatten(data);
            }
            catch (IllegalArgumentException argEx) {
                if (beanToStructCache.containsKey(data.getClass())) {
                    mwArray.addAllDimension(Arrays.asList(1L, 1L));
                    this.updateMATLABArrayBuilderStruct(mwArray, new Object[]{data}, beanToStructCache);
                    return mwArray.build();
                }
                throw argEx;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Trouble processing input data of type : " + inputType.getName() + "\n", ex);
        }
        List<Integer> dimArr = MATLABArrayBuilder.getDimensions(data);
        for (int dim : dimArr) {
            mwArray.addDimension(dim);
        }
        try {
            Class<?> dataClassType = flattenedData.getClass();
            if (flattenedDataClassTypes.contains(dataClassType)) {
                MATLABPrimitiveArrayBuilder.newInstance(flattenedData, mwArray, dataClassType);
            } else {
                this.updateMATLABObjectArrayBuilder((Object[])flattenedData, mwArray, elementClass);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Trouble creating MATLABArray from input data.\n", ex);
        }
        return mwArray.build();
    }

    public static List<Integer> getDimensions(Object data) {
        if (!data.getClass().isArray()) {
            if (data.getClass() == String.class) {
                return Arrays.asList(1, ((String)data).length());
            }
            return Arrays.asList(1, 1);
        }
        List<Integer> dimsArr = ArrayUtils.getDimsArray(data);
        if (dimsArr.size() == 1) {
            return Arrays.asList(1, dimsArr.get(0));
        }
        return dimsArr;
    }

    private void updateMATLABObjectArrayBuilder(Object[] flattenedData, MATLABArray.MATLAB_Array.Builder mwArray, Class elementClass) {
        Map<Class, Map<String, Method>> beanToStructCache = this.mwAttributesContainer.getChildrenStructsForParentMLInput(elementClass);
        if (beanToStructCache.containsKey(flattenedData.getClass().getComponentType())) {
            this.updateMATLABArrayBuilderStruct(mwArray, flattenedData, beanToStructCache);
        } else {
            this.updateMATLABArrayBuilderCell(mwArray, flattenedData, elementClass);
        }
    }

    private void updateMATLABArrayBuilderStruct(MATLABArray.MATLAB_Array.Builder mwArray, Object[] flattenedData, Map<Class, Map<String, Method>> beanToStructCache) {
        mwArray.setType(MATLABArray.MATLAB_Array.MWType.STRUCT);
        Class<?> eleClass = flattenedData[0].getClass();
        Map<String, Method> gettersMap = beanToStructCache.get(eleClass);
        MATLABArray.MATLAB_Array.Struct.Builder mwStruct = MATLABArray.MATLAB_Array.Struct.newBuilder();
        Set<String> fieldNames = gettersMap.keySet();
        mwStruct.addAllFieldNames(fieldNames);
        for (Object val : flattenedData) {
            for (String fieldName : fieldNames) {
                try {
                    Object inputToFactory = null;
                    if (val != null) {
                        inputToFactory = gettersMap.get(fieldName).invoke(val, new Object[0]);
                    }
                    mwStruct.addElements(this.flattenAndIdentifyNextType(inputToFactory, eleClass));
                }
                catch (Exception ex) {
                    throw new RuntimeException("An error occurred while marshaling Java type : " + eleClass.getName() + ", into MATLAB structure. The error occurred while marshaling the value of property : " + fieldName + ", of this Java type.", ex);
                }
            }
        }
        mwArray.setExtension(MATLABArray.MATLAB_Array.struct, mwStruct.build());
    }

    private void updateMATLABArrayBuilderCell(MATLABArray.MATLAB_Array.Builder mwArray, Object[] flattenedData, Class elementClass) {
        mwArray.setType(MATLABArray.MATLAB_Array.MWType.CELL);
        MATLABArray.MATLAB_Array.Cell.Builder ext = MATLABArray.MATLAB_Array.Cell.newBuilder();
        for (Object val : flattenedData) {
            ext.addElements(this.flattenAndIdentifyNextType(val, elementClass));
        }
        mwArray.setExtension(MATLABArray.MATLAB_Array.cell, ext.build());
    }

    private MATLABArray.MATLAB_Array createEmptyMATLABArray() {
        MATLABArray.MATLAB_Array.Builder mwArray = MATLABArray.MATLAB_Array.newBuilder();
        mwArray.setType(MATLABArray.MATLAB_Array.MWType.DOUBLE);
        mwArray.addDimension(0L);
        mwArray.addDimension(0L);
        MATLABArray.MATLAB_Array.Double.Builder dbl = MATLABArray.MATLAB_Array.Double.newBuilder();
        mwArray.setExtension(MATLABArray.MATLAB_Array.mwdouble, dbl.build());
        return mwArray.build();
    }

    static {
        Collections.addAll(flattenedDataClassTypes, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[].class, char[].class, String[].class);
    }
}

