/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MWMarshalingRules;
import com.mathworks.mps.client.annotations.MWStructureList;
import com.mathworks.mps.client.internal.ArrayUtils;
import com.mathworks.mps.client.internal.MWStructInfo;
import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryConstructor;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryMaker;
import com.mathworks.mps.client.internal.MWStructToBeanFactorySetter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MWAttributesContainer {
    private final List<Class> mwStructList;
    private final Map<Class, Map<Class, Map<String, Method>>> mlInputStructCache = new HashMap<Class, Map<Class, Map<String, Method>>>();
    private final Map<Class, Map<MWStructInfo, MWStructToBeanFactory>> mlOutputStructCache = new HashMap<Class, Map<MWStructInfo, MWStructToBeanFactory>>();

    public MWAttributesContainer(MWMarshalingRules mwMarshalingRules) {
        this.mwStructList = Collections.unmodifiableList(mwMarshalingRules.getStructTypes());
        this.updateMLInputStructCache();
        this.analyzeCircularDependencyForInputs();
        this.updateMLOutputStructCache();
        this.analyzeCircularDependencyForOutputs();
    }

    public Map<Class, Map<String, Method>> getChildrenStructsForParentMLInput(Class parent) {
        return this.mlInputStructCache.get(parent);
    }

    public Map<MWStructInfo, MWStructToBeanFactory> getChildrenStructsForParentMLOutput(Class parent) {
        return this.mlOutputStructCache.get(parent);
    }

    private void analyzeCircularDependencyForOutputs() {
        Set<MWStructInfo> parents = this.mlOutputStructCache.get(Method.class).keySet();
        HashSet<Class> typeSet = new HashSet<Class>();
        for (MWStructInfo parent : parents) {
            Class parentType = parent.getBeanType();
            if (parentType == null) continue;
            typeSet.add(parentType);
            this.analyzeCircularDependencyForOutputs(this.mlOutputStructCache.get(parentType), typeSet);
            typeSet.remove(parentType);
        }
    }

    private void analyzeCircularDependencyForOutputs(Map<MWStructInfo, MWStructToBeanFactory> map, Set<Class> typeSet) {
        Set<MWStructInfo> children = map.keySet();
        if (children.size() == 0) {
            return;
        }
        for (MWStructInfo child : children) {
            Class childType = child.getBeanType();
            if (childType == null) continue;
            if (!typeSet.contains(childType)) {
                typeSet.add(childType);
                this.analyzeCircularDependencyForOutputs(this.mlOutputStructCache.get(childType), typeSet);
                typeSet.remove(childType);
                continue;
            }
            throw new IllegalArgumentException(this.getCircularDependencyExceptionText(childType));
        }
    }

    private void analyzeCircularDependencyForInputs() {
        Set<Class> parents = this.mlInputStructCache.get(Method.class).keySet();
        HashSet<Class> typeSet = new HashSet<Class>();
        for (Class parent : parents) {
            typeSet.add(parent);
            this.analyzeCircularDependencyForInputs(this.mlInputStructCache.get(parent), typeSet);
            typeSet.remove(parent);
        }
    }

    private void analyzeCircularDependencyForInputs(Map<Class, Map<String, Method>> map, Set<Class> typeSet) {
        Set<Class> children = map.keySet();
        if (children.size() == 0) {
            return;
        }
        for (Class child : children) {
            if (!typeSet.contains(child)) {
                typeSet.add(child);
                this.analyzeCircularDependencyForInputs(this.mlInputStructCache.get(child), typeSet);
                typeSet.remove(child);
                continue;
            }
            throw new IllegalArgumentException(this.getCircularDependencyExceptionText(child));
        }
    }

    private void updateMLOutputStructCache() {
        this.mlOutputStructCache.put(Method.class, new HashMap());
        for (Class cls : this.mwStructList) {
            this.updateMLOutputStructCache(Method.class, cls);
        }
    }

    private void updateMLOutputStructCache(Class parent, Class child) {
        Class childScalar = ArrayUtils.getArrayElementType(child);
        if (!(childScalar.isPrimitive() || childScalar.equals(String.class) || childScalar.equals(Object.class))) {
            if (parent.equals(childScalar)) {
                throw new IllegalArgumentException("While analyzing user defined types for MATLAB output struct, a circular dependency was detected for Java type : " + parent.getName() + ".");
            }
            Map<MWStructInfo, MWStructToBeanFactory> innerCache = this.mlOutputStructCache.get(parent);
            List<MWStructToBeanFactory> factoryList = MWStructToBeanFactoryMaker.createFactoryList(childScalar);
            if (factoryList.size() > 0) {
                int idx = 0;
                for (MWStructToBeanFactory factory : factoryList) {
                    Class[] mwStructInfo = new MWStructInfo(factory.getPropNames());
                    if (idx == 0) {
                        mwStructInfo.setBeanType(childScalar);
                    }
                    if (innerCache.containsKey(mwStructInfo)) continue;
                    innerCache.put((MWStructInfo)mwStructInfo, factory);
                    ++idx;
                }
                if (!this.mlOutputStructCache.containsKey(childScalar)) {
                    this.mlOutputStructCache.put(childScalar, new HashMap());
                    MWStructureList clsAnnotation = childScalar.getAnnotation(MWStructureList.class);
                    if (clsAnnotation != null) {
                        Class[] clsList;
                        for (Class cls : clsList = clsAnnotation.value()) {
                            this.updateMLOutputStructCache(childScalar, cls);
                        }
                    }
                    for (MWStructToBeanFactory factory : factoryList) {
                        Class[] clsList;
                        Constructor constr;
                        MWStructureList structAnnotation;
                        if (factory instanceof MWStructToBeanFactorySetter) {
                            Map<String, Method> setterMap = ((MWStructToBeanFactorySetter)factory).getBeanSetterMap();
                            Collection<Method> setters = setterMap.values();
                            for (Method setter : setters) {
                                Class[] clsList2;
                                MWStructureList structAnnotation2 = setter.getAnnotation(MWStructureList.class);
                                if (structAnnotation2 == null) continue;
                                for (Class cls : clsList2 = structAnnotation2.value()) {
                                    this.updateMLOutputStructCache(childScalar, cls);
                                }
                            }
                            continue;
                        }
                        if (!(factory instanceof MWStructToBeanFactoryConstructor) || (structAnnotation = (constr = ((MWStructToBeanFactoryConstructor)factory).getBeanConstructor()).getAnnotation(MWStructureList.class)) == null) continue;
                        for (Class cls : clsList = structAnnotation.value()) {
                            this.updateMLOutputStructCache(childScalar, cls);
                        }
                    }
                }
            }
        }
    }

    private void updateMLInputStructCache() {
        this.mlInputStructCache.put(Method.class, new HashMap());
        for (Class cls : this.mwStructList) {
            this.updateMLInputStructCache(Method.class, cls);
        }
    }

    private void updateMLInputStructCache(Class parent, Class child) {
        Class childScalar = ArrayUtils.getArrayElementType(child);
        if (!(childScalar.isPrimitive() || childScalar.equals(String.class) || childScalar.equals(Object.class))) {
            List<PropertyDescriptor> pDescList;
            if (parent.equals(childScalar)) {
                throw new IllegalArgumentException("While analyzing user defined types for MATLAB input struct, a circular dependency was detected for Java type : " + parent.getName() + ".");
            }
            Map<Class, Map<String, Method>> innerCache = this.mlInputStructCache.get(parent);
            if (!innerCache.containsKey(childScalar) && (pDescList = this.getPropertyDescriptorsWithGetters(childScalar)).size() > 0) {
                HashMap<String, Method> stringMethodMap = new HashMap<String, Method>();
                for (PropertyDescriptor pDesc : pDescList) {
                    stringMethodMap.put(pDesc.getDisplayName(), pDesc.getReadMethod());
                }
                innerCache.put(childScalar, stringMethodMap);
                if (!this.mlInputStructCache.containsKey(childScalar)) {
                    this.mlInputStructCache.put(childScalar, new HashMap());
                    MWStructureList clsAnnotation = childScalar.getAnnotation(MWStructureList.class);
                    if (clsAnnotation != null) {
                        Class[] clsList;
                        for (Class cls : clsList = clsAnnotation.value()) {
                            this.updateMLInputStructCache(childScalar, cls);
                        }
                    }
                    for (PropertyDescriptor pDesc : pDescList) {
                        Class[] clsList;
                        MWStructureList structAnnotation = pDesc.getReadMethod().getAnnotation(MWStructureList.class);
                        if (structAnnotation == null) continue;
                        for (Class cls : clsList = structAnnotation.value()) {
                            this.updateMLInputStructCache(childScalar, cls);
                        }
                    }
                }
            }
        }
    }

    private List<PropertyDescriptor> getPropertyDescriptorsWithGetters(Class child) {
        ArrayList<PropertyDescriptor> pDescList = new ArrayList<PropertyDescriptor>();
        try {
            BeanInfo bInfo = Introspector.getBeanInfo(child, Object.class);
            PropertyDescriptor[] pDesc = bInfo.getPropertyDescriptors();
            if (pDesc != null && pDesc.length > 0) {
                for (PropertyDescriptor p : pDesc) {
                    if (p.getReadMethod() == null) continue;
                    pDescList.add(p);
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return pDescList;
    }

    private String getCircularDependencyExceptionText(Class beanType) {
        return "While analyzing Java type as a possible MATLAB struct convertible type, a circular dependency was detected for : " + beanType.getName();
    }
}

