/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MWCustomSSLContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class MWSSLContext {
    private static final SSLContext defaultContext;

    public static SSLContext getDefault() throws GeneralSecurityException, IllegalAccessException, IOException, PrivilegedActionException {
        return defaultContext;
    }

    private static TrustManager[] getDefaultTrustManager() throws GeneralSecurityException, IOException, PrivilegedActionException {
        KeyStore ks = MWSSLContext.getCacertsKeyStore();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        return tmf.getTrustManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getCacertsKeyStore() throws GeneralSecurityException, IOException, PrivilegedActionException {
        final HashMap props = new HashMap();
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                props.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
                props.put("javaHome", System.getProperty("java.home"));
                props.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
                props.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
                props.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
                return null;
            }
        });
        String storeFileName = (String)props.get("trustStore");
        KeyStore ks = null;
        try (FileInputStream fis = null;){
            if (!"NONE".equals(storeFileName)) {
                File storeFile;
                if (storeFileName != null) {
                    storeFile = new File(storeFileName);
                    fis = MWSSLContext.getFileInputStream(storeFile);
                } else {
                    String javaHome = (String)props.get("javaHome");
                    storeFile = MWSSLContext.fullfile(javaHome, "lib", "security", "jssecacerts");
                    fis = MWSSLContext.getFileInputStream(storeFile);
                    if (fis == null) {
                        storeFile = MWSSLContext.fullfile(javaHome, "lib", "security", "cacerts");
                        fis = MWSSLContext.getFileInputStream(storeFile);
                    }
                }
            }
            String defaultTrustStoreType = (String)props.get("trustStoreType");
            String defaultTrustStoreProvider = (String)props.get("trustStoreProvider");
            if (defaultTrustStoreType.length() != 0) {
                ks = defaultTrustStoreProvider.length() == 0 ? KeyStore.getInstance(defaultTrustStoreType) : KeyStore.getInstance(defaultTrustStoreType, defaultTrustStoreProvider);
                char[] passwd = null;
                String defaultTrustStorePassword = (String)props.get("trustStorePasswd");
                if (defaultTrustStorePassword.length() != 0) {
                    passwd = defaultTrustStorePassword.toCharArray();
                }
                ks.load(fis, passwd);
                if (passwd != null) {
                    for (int i = 0; i < passwd.length; ++i) {
                        passwd[i] = '\u0000';
                    }
                }
            }
        }
        return ks;
    }

    private static FileInputStream getFileInputStream(final File file) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                try {
                    if (file.exists()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyManager[] getDefaultKeyManager() throws GeneralSecurityException, IOException, PrivilegedActionException {
        final HashMap props = new HashMap();
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                props.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                props.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                props.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                props.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                return null;
            }
        });
        final String defaultKeyStore = (String)props.get("keyStore");
        String defaultKeyStoreType = (String)props.get("keyStoreType");
        String defaultKeyStoreProvider = (String)props.get("keyStoreProvider");
        String P11KEYSTORE = "PKCS11";
        String NONE = "NONE";
        if ("PKCS11".equals(defaultKeyStoreType) && !"NONE".equals(defaultKeyStore)) {
            throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
        }
        FileInputStream fs = null;
        KeyStore ks = null;
        char[] passwd = null;
        try {
            String defaultKeyStorePassword;
            if (defaultKeyStore.length() != 0 && !"NONE".equals(defaultKeyStore)) {
                fs = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws Exception {
                        return new FileInputStream(defaultKeyStore);
                    }
                });
            }
            if ((defaultKeyStorePassword = (String)props.get("keyStorePasswd")).length() != 0) {
                passwd = defaultKeyStorePassword.toCharArray();
            }
            if (defaultKeyStoreType.length() != 0) {
                ks = defaultKeyStoreProvider.length() == 0 ? KeyStore.getInstance(defaultKeyStoreType) : KeyStore.getInstance(defaultKeyStoreType, defaultKeyStoreProvider);
                ks.load(fs, passwd);
            }
        }
        finally {
            if (fs != null) {
                fs.close();
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if ("PKCS11".equals(defaultKeyStoreType)) {
            kmf.init(ks, null);
        } else {
            kmf.init(ks, passwd);
        }
        KeyManager[] defaultKeyManagers = kmf.getKeyManagers();
        return defaultKeyManagers;
    }

    private static File fullfile(String ... parts) {
        File f = null;
        for (String s : parts) {
            f = null == f ? new File(s) : new File(f, s);
        }
        return f;
    }

    static {
        try {
            defaultContext = MWCustomSSLContext.getInstance("TLSv1");
            defaultContext.init(MWSSLContext.getDefaultKeyManager(), MWSSLContext.getDefaultTrustManager(), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

