/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryMaker;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MWStructToBeanFactoryConstructor
extends MWStructToBeanFactory {
    private Constructor beanConstructor;
    private List<String> constructorPropAnnotVal;

    public MWStructToBeanFactoryConstructor(Class beanType, List<String> fieldNames, Map<String, Class> beanTypeMap, Constructor beanConstructor) {
        super(beanType, fieldNames, beanTypeMap);
        this.beanConstructor = beanConstructor;
        this.constructorPropAnnotVal = Arrays.asList(MWStructToBeanFactoryMaker.getConstructorProperties(beanConstructor));
    }

    @Override
    public Object newInstance(List<String> structFieldNames, Object ... args) {
        Object beanInst = null;
        try {
            int numProp = this.constructorPropAnnotVal.size();
            Object[] constrArgs = new Object[numProp];
            for (int i = 0; i < numProp; ++i) {
                String propName = this.constructorPropAnnotVal.get(i);
                constrArgs[i] = args[structFieldNames.indexOf(propName)];
            }
            beanInst = this.beanConstructor.newInstance(constrArgs);
        }
        catch (Exception ex) {
            throw new RuntimeException("An error occurred while marshaling a MATLAB structure with fields : " + structFieldNames + ", into a Java type : " + this.beanType.getName(), ex);
        }
        return beanInst;
    }

    public Constructor getBeanConstructor() {
        return this.beanConstructor;
    }
}

