/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.mps.client.MWRequestStateVisitor;
import com.mathworks.mps.client.internal.async.MWFuture;
import java.net.URL;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

class FutureVisitor<T>
implements MWRequestStateVisitor<T> {
    private MWFuture<T> future;

    public FutureVisitor(MWFuture<T> future) {
        this.future = future;
    }

    @Override
    public void cancelled() {
        this.setCancellationException("The request has been cancelled");
    }

    @Override
    public void expired() {
    }

    @Override
    public void failed(Exception e) {
        this.setException(e);
    }

    @Override
    public void interrupted() {
        this.setInterruptedException(new InterruptedException("The client has already been closed"));
    }

    @Override
    public void inQueue(long timeStamp, URL requestURL) {
    }

    @Override
    public void processing(long timestamp, URL requestURL) {
        this.setStateToRunning();
    }

    @Override
    public void ready(T responseData) {
        this.setResult(responseData);
    }

    @Override
    public void sending(byte[] data, URL serviceURL) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setException(Exception ex) {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.setExecException(new ExecutionException(ex));
            this.future.finished = true;
            this.future.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCancellationException(String message) {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.setCancelException(new CancellationException(message));
            this.future.finished = true;
            this.future.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterruptedException(InterruptedException ex) {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.setInterruptedException(ex);
            this.future.finished = true;
            this.future.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(T responseData) {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.set(responseData);
            this.future.finished = true;
            this.future.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateToRunning() {
        Object object = this.future.lock;
        synchronized (object) {
            this.future.setState(0);
            this.future.lock.notify();
        }
    }
}

