/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.client.methods.HttpGet;
import com.mathworks.apache.http.client.methods.HttpPost;
import com.mathworks.apache.http.client.methods.HttpUriRequest;
import com.mathworks.mps.client.MWClient;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWRequest;
import com.mathworks.mps.client.MWRequestListener;
import com.mathworks.mps.client.MWRequestState;
import com.mathworks.mps.client.MWRequestStateVisitor;
import com.mathworks.mps.client.internal.ApacheFevalHandler;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.async.CancelledMWRequestState;
import com.mathworks.mps.client.internal.async.FutureVisitor;
import com.mathworks.mps.client.internal.async.InQueueMWRequestState;
import com.mathworks.mps.client.internal.async.InterruptedMWRequestState;
import com.mathworks.mps.client.internal.async.MWFuture;
import com.mathworks.mps.client.internal.async.MWRequestInfo;
import com.mathworks.mps.client.internal.async.ProcessingMWRequestState;
import com.mathworks.mps.client.internal.async.SendingMWRequestState;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class MWRequestImpl<T>
implements MWRequest<T> {
    private MWRequestState<T> state;
    private MWRequestListener<T> listener = null;
    private final MWFuture<T> future;
    private final MWClient client;
    private final MWRequestStateVisitor<T> visitor;
    private final MWRequestInfo<T> clientRequestInfo;
    private ApacheFevalHandler fevalHandler;
    private ApacheHttpClient apacheClient;
    private UUID tempId;
    public final Object lock = new Object();
    public boolean markedForCancellation = false;
    public HttpUriRequest httpPost;
    public HttpUriRequest httpGetResponse;
    public HttpUriRequest httpGetError;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public MWRequestImpl(MWClient client, MWRequestListener<T> listener, MWRequestInfo<T> clientRequestInfo, ApacheFevalHandler fevalHandler) {
        this.future = new MWFuture(this);
        this.client = client;
        this.listener = listener;
        this.apacheClient = fevalHandler.getApacheHttpClient();
        this.visitor = new FutureVisitor<T>(this.future);
        this.clientRequestInfo = clientRequestInfo;
        this.fevalHandler = fevalHandler;
        this.tempId = UUID.randomUUID();
    }

    @Override
    public void release() {
        if (this.fevalHandler.isClosed()) {
            throw new IllegalStateException("MWHttpClient that provided the proxy object has already been closed");
        }
        if (!this.state.isTerminal()) {
            throw new IllegalStateException("A request has to be in a terminal state to be released.");
        }
        if (this.clientRequestInfo == null || this.clientRequestInfo.getRequestUrl() == null) {
            return;
        }
        String deleteUrl = this.clientRequestInfo.getInstance().getServerUri() + this.clientRequestInfo.getRequestUrl();
        this.apacheClient.executeDelete(deleteUrl, this.clientRequestInfo.getInstance().getHttpContext());
    }

    @Override
    public Future<T> getFuture() {
        return this.future;
    }

    @Override
    public MWRequestState<T> getState() {
        return this.state;
    }

    @Override
    public MWClient getClient() {
        return this.client;
    }

    public MWRequestInfo<T> getClientRequestInfo() {
        return this.clientRequestInfo;
    }

    public MWRequestStateVisitor<T> getFutureVisitor() {
        return this.visitor;
    }

    public UUID getTempId() {
        return this.tempId;
    }

    public void markReadingResponse(HttpGet httpGet) {
        this.httpGetResponse = httpGet;
    }

    public void markReadingError(HttpGet httpGet) {
        this.httpGetError = httpGet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCreated() {
        Object object = this.lock;
        synchronized (object) {
            this.httpPost = null;
            this.apacheClient.pendingRequests.remove(this.tempId);
        }
    }

    private boolean isValidUpdateRequest(MWRequestState<T> newState) {
        boolean isValid = false;
        StateComparator<T> comparator = new StateComparator<T>();
        if (comparator.compare(this.state, newState) == -1) {
            isValid = true;
        }
        return isValid;
    }

    private boolean setState(MWRequestState<T> newState) {
        boolean isValid = this.isValidUpdateRequest(newState);
        if (isValid) {
            this.state = newState;
            newState.visit(this.visitor);
        }
        return isValid;
    }

    private void notifyListeners() {
        if (this.listener != null) {
            this.listener.notify(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStateAndNotify(MWRequestState<T> newState) {
        boolean updated = false;
        Object object = this.lock;
        synchronized (object) {
            updated = this.setState(newState);
        }
        if (updated) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state.isTerminal()) {
                return false;
            }
            if (this.state.getClass() == SendingMWRequestState.class) {
                this.markedForCancellation = true;
            } else {
                this.sendCancelRequest();
            }
            this.setState(new CancelledMWRequestState());
        }
        this.notifyListeners();
        return true;
    }

    public void sendCancelRequest() {
        String cancelUrl = this.clientRequestInfo.getInstance().getServerUri() + this.clientRequestInfo.getRequestUrl() + "/cancel";
        this.apacheClient.executePostCancel(new HttpPost(cancelUrl), null, this.clientRequestInfo.getInstance().getHttpContext(), null);
        String requestUrl = this.clientRequestInfo.getRequestUrl();
        String sessionID = this.clientRequestInfo.getInstance().getSessionId();
        this.apacheClient.requestsCreated.get(sessionID).remove(requestUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        boolean isUpdated = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.httpPost != null) {
                this.httpPost.abort();
                isUpdated = this.setState(new InterruptedMWRequestState());
            }
        }
        if (isUpdated) {
            this.notifyListeners();
        }
    }

    public String toString() {
        if (this.clientRequestInfo == null || this.clientRequestInfo.getInstance() == null) {
            return null;
        }
        return this.clientRequestInfo.getInstance().getServerUri() + this.clientRequestInfo.getRequestUrl();
    }

    @Override
    public String getRequestURL() {
        return this.clientRequestInfo == null ? null : this.clientRequestInfo.getRequestUrl();
    }

    private class StateComparator<T>
    implements Comparator<MWRequestState<T>> {
        private StateComparator() {
        }

        @Override
        public int compare(MWRequestState<T> currentState, MWRequestState<T> newState) {
            if (currentState == null) {
                return -1;
            }
            if (newState.getClass() == InterruptedMWRequestState.class && (MWRequestImpl.this.httpGetResponse != null || MWRequestImpl.this.httpGetError != null)) {
                return 1;
            }
            Class<?> currentStateType = currentState.getClass();
            if (currentStateType == newState.getClass()) {
                return 0;
            }
            if (currentState.isTerminal() && !newState.isTerminal()) {
                return 1;
            }
            if (currentStateType == SendingMWRequestState.class ? newState.isTerminal() || newState.getClass() == ProcessingMWRequestState.class || newState.getClass() == InQueueMWRequestState.class || newState.getClass() == InterruptedMWRequestState.class : (currentStateType == InQueueMWRequestState.class ? newState.isTerminal() || newState.getClass() == ProcessingMWRequestState.class || newState.getClass() == InterruptedMWRequestState.class : currentStateType == ProcessingMWRequestState.class && (newState.isTerminal() || newState.getClass() == InterruptedMWRequestState.class))) {
                return -1;
            }
            return 1;
        }
    }
}

