/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.mps.client.MWHttpException;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.HTTPErrorInfo;
import com.mathworks.mps.client.internal.async.FailedMWRequestState;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import java.io.IOException;
import java.io.InputStream;

public class OnErrorCallback
implements FutureCallback<HttpResponse> {
    private MWRequestImpl request;
    private ApacheHttpClient apacheClient;

    public OnErrorCallback(MWRequestImpl request, ApacheHttpClient apacheClient) {
        this.request = request;
        this.apacheClient = apacheClient;
    }

    @Override
    public void failed(Exception ex) {
        this.request.updateStateAndNotify(new FailedMWRequestState(ex));
        this.apacheClient.getClientUsageLock().usageExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(HttpResponse response) {
        try {
            HTTPErrorInfo.HTTP_Error_Info errorInfo = this.parseHttpErrorInfo(response);
            MWHttpException httpError = new MWHttpException(errorInfo.getHttpCode(), errorInfo.getHttpMessage());
            this.request.updateStateAndNotify(new FailedMWRequestState(httpError));
        }
        catch (IOException e) {
            this.request.updateStateAndNotify(new FailedMWRequestState(e));
        }
        finally {
            this.apacheClient.requestsCreated.remove(this.request.getClientRequestInfo().getRequestUrl());
            this.apacheClient.getClientUsageLock().usageExit();
        }
    }

    @Override
    public void cancelled() {
        this.apacheClient.getClientUsageLock().usageExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPErrorInfo.HTTP_Error_Info parseHttpErrorInfo(HttpResponse response) throws IOException {
        try (InputStream iStream = response.getEntity().getContent();){
            CodedInputStream iStreamCoded = CodedInputStream.newInstance(iStream);
            iStreamCoded.setSizeLimit(this.apacheClient.getResponseSizeLimit());
            HTTPErrorInfo.HTTP_Error_Info hTTP_Error_Info = HTTPErrorInfo.HTTP_Error_Info.parseFrom(iStreamCoded);
            return hTTP_Error_Info;
        }
    }
}

