/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class WaitNotifier {
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final Lock waitLock = new ReentrantLock();
    private final Condition stateChanged = this.waitLock.newCondition();

    public void update() {
        this.waitLock.lock();
        try {
            this.stateChanged.signalAll();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    public void cancel() {
        if (this.isCancelled.compareAndSet(false, true)) {
            this.update();
        }
    }

    public void reset() {
        this.isCancelled.compareAndSet(true, false);
    }

    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Supplier<Boolean> action, Duration waitDuration) throws TimeoutException, CancellationException, InterruptedException {
        if (this.isCancelled.get()) {
            throw new CancellationException();
        }
        long nanos = waitDuration.toNanos();
        if (nanos <= 0L) {
            throw new TimeoutException();
        }
        this.waitLock.lock();
        try {
            while (!action.get().booleanValue()) {
                if ((nanos = this.stateChanged.awaitNanos(nanos)) <= 0L) {
                    throw new TimeoutException();
                }
                if (!this.isCancelled.get()) continue;
                throw new CancellationException();
            }
        }
        finally {
            this.waitLock.unlock();
        }
    }

    public void sleepFor(Duration sleepDuration) throws CancellationException, InterruptedException {
        if (this.isCancelled.get()) {
            throw new CancellationException();
        }
        long nanos = sleepDuration.toNanos();
        if (nanos <= 0L) {
            return;
        }
        this.waitLock.lock();
        try {
            do {
                if ((nanos = this.stateChanged.awaitNanos(nanos)) > 0L) continue;
                return;
            } while (!this.isCancelled.get());
            throw new CancellationException();
        }
        finally {
            this.waitLock.unlock();
        }
    }
}

