/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio.client;

import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.annotation.ThreadSafe;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import com.mathworks.apache.http.nio.client.HttpPipeliningClient;
import com.mathworks.apache.http.nio.client.methods.HttpAsyncMethods;
import com.mathworks.apache.http.nio.protocol.HttpAsyncRequestProducer;
import com.mathworks.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import com.mathworks.apache.http.protocol.HttpContext;
import com.mathworks.apache.http.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

@ThreadSafe
public abstract class CloseableHttpPipeliningClient
extends CloseableHttpAsyncClient
implements HttpPipeliningClient {
    @Override
    public <T> Future<List<T>> execute(HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, FutureCallback<List<T>> callback) {
        return this.execute(target, requestProducers, responseConsumers, HttpClientContext.create(), callback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost target, List<HttpRequest> requests, FutureCallback<List<HttpResponse>> callback) {
        return this.execute(target, requests, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost target, List<HttpRequest> requests, HttpContext context, FutureCallback<List<HttpResponse>> callback) {
        Args.notEmpty(requests, "HTTP request list");
        ArrayList<HttpAsyncRequestProducer> requestProducers = new ArrayList<HttpAsyncRequestProducer>(requests.size());
        ArrayList<HttpAsyncResponseConsumer<HttpResponse>> responseConsumers = new ArrayList<HttpAsyncResponseConsumer<HttpResponse>>(requests.size());
        for (int i = 0; i < requests.size(); ++i) {
            HttpRequest request = requests.get(i);
            requestProducers.add(HttpAsyncMethods.create(target, request));
            responseConsumers.add(HttpAsyncMethods.createConsumer());
        }
        return this.execute(target, requestProducers, responseConsumers, context, callback);
    }
}

