/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client;

import java.io.Serializable;

public class MATLABStackFrame
implements Serializable {
    private final String file;
    private final String name;
    private final int line;

    public MATLABStackFrame(String file, String name, int line) {
        if (file.length() == 0 || name.length() == 0) {
            throw new IllegalArgumentException("Either the file or name property of MATLAB stack frame was of 0 length");
        }
        if (line <= 0) {
            throw new IllegalArgumentException("Line number must be greater than 0");
        }
        this.file = file;
        this.name = name;
        this.line = line;
    }

    public String getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public String toString() {
        return "Error in => file: " + this.file + ", function name: " + this.name + ", at line: " + this.line;
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof MATLABStackFrame)) {
            return false;
        }
        MATLABStackFrame fr = (MATLABStackFrame)obj;
        return this == obj || fr.getFile().equals(this.file) && fr.getName().equals(this.name) && fr.getLine() == this.line;
    }

    public int hashCode() {
        return this.file.hashCode() + this.name.hashCode() + new Integer(this.line).hashCode();
    }
}

