/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.internal.ArrayUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;

public class Flattener {
    public static Object flatten(Object src) {
        Object dst = null;
        Class arrEleType = null;
        Class dstType = null;
        if (src.getClass().isArray()) {
            arrEleType = ArrayUtils.getArrayElementType(src);
            dstType = ArrayUtils.unBoxIfBoxedType(arrEleType);
            List<Integer> len = ArrayUtils.getDimsArray(src);
            if (len.contains(0)) {
                dst = Array.newInstance(dstType, 0);
            } else {
                List<Integer> stride = ArrayUtils.getStrides(len);
                dst = Array.newInstance(dstType, (int)stride.get(stride.size() - 1));
                String method = "genericFlatten" + ArrayUtils.getCamelCasedClassName(arrEleType);
                try {
                    Method m = Flattener.class.getMethod(method, dst.getClass(), Object.class, Integer.TYPE, List.class, List.class, Integer.TYPE);
                    m.invoke(null, dst, src, 0, stride, len, len.size());
                }
                catch (NoSuchMethodException ex) {
                    Flattener.genericFlattenJavaLangObject((Object[])dst, src, 0, stride, len, len.size());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Generic handling of input data failed for type : " + arrEleType.getName(), ex);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported input data type : " + src.getClass().getName());
        }
        return dst;
    }

    public static short[] flatten(Short src) {
        boolean stride_0 = true;
        short[] dst = new short[]{src};
        return dst;
    }

    public static short[] flatten(Short[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new short[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        short[] dst = new short[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static short[] flatten(Short[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new short[0];
        }
        Short[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new short[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        short[] dst = new short[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Short[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static short[] flatten(Short[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new short[0];
        }
        Short[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new short[0];
        }
        Short[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new short[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        short[] dst = new short[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Short[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                Short[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangShort(short[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            Short[] oneDimSrc = (Short[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangShort(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static float[] flatten(Float src) {
        boolean stride_0 = true;
        float[] dst = new float[]{src.floatValue()};
        return dst;
    }

    public static float[] flatten(Float[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new float[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        float[] dst = new float[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0].floatValue();
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static float[] flatten(Float[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new float[0];
        }
        Float[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new float[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        float[] dst = new float[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Float[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1].floatValue();
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static float[] flatten(Float[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new float[0];
        }
        Float[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new float[0];
        }
        Float[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new float[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        float[] dst = new float[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Float[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                Float[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2].floatValue();
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangFloat(float[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            Float[] oneDimSrc = (Float[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i].floatValue();
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangFloat(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static byte[] flatten(Byte src) {
        boolean stride_0 = true;
        byte[] dst = new byte[]{src};
        return dst;
    }

    public static byte[] flatten(Byte[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new byte[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        byte[] dst = new byte[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static byte[] flatten(Byte[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new byte[0];
        }
        Byte[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new byte[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        byte[] dst = new byte[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Byte[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static byte[] flatten(Byte[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new byte[0];
        }
        Byte[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new byte[0];
        }
        Byte[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new byte[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        byte[] dst = new byte[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Byte[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                Byte[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangByte(byte[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            Byte[] oneDimSrc = (Byte[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangByte(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static Object[] flatten(Object[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new Object[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        Object[] dst = new Object[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static Object[] flatten(Object[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new Object[0];
        }
        Object[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new Object[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        Object[] dst = new Object[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Object[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static Object[] flatten(Object[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new Object[0];
        }
        Object[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new Object[0];
        }
        Object[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new Object[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        Object[] dst = new Object[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Object[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                Object[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangObject(Object[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            Object[] oneDimSrc = (Object[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangObject(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static char[] flatten(char src) {
        boolean stride_0 = true;
        char[] dst = new char[]{src};
        return dst;
    }

    public static char[] flatten(char[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new char[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        char[] dst = new char[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static char[] flatten(char[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new char[0];
        }
        char[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new char[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        char[] dst = new char[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            char[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static char[] flatten(char[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new char[0];
        }
        char[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new char[0];
        }
        char[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new char[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        char[] dst = new char[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            char[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                char[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenChar(char[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            char[] oneDimSrc = (char[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenChar(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static long[] flatten(long src) {
        boolean stride_0 = true;
        long[] dst = new long[]{src};
        return dst;
    }

    public static long[] flatten(long[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new long[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        long[] dst = new long[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static long[] flatten(long[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new long[0];
        }
        long[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new long[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        long[] dst = new long[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            long[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static long[] flatten(long[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new long[0];
        }
        long[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new long[0];
        }
        long[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new long[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        long[] dst = new long[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            long[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                long[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenLong(long[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            long[] oneDimSrc = (long[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenLong(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static char[] flatten(Character src) {
        boolean stride_0 = true;
        char[] dst = new char[]{src.charValue()};
        return dst;
    }

    public static char[] flatten(Character[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new char[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        char[] dst = new char[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0].charValue();
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static char[] flatten(Character[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new char[0];
        }
        Character[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new char[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        char[] dst = new char[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Character[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1].charValue();
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static char[] flatten(Character[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new char[0];
        }
        Character[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new char[0];
        }
        Character[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new char[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        char[] dst = new char[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Character[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                Character[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2].charValue();
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangCharacter(char[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            Character[] oneDimSrc = (Character[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i].charValue();
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangCharacter(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static boolean[] flatten(boolean src) {
        boolean stride_0 = true;
        boolean[] dst = new boolean[]{src};
        return dst;
    }

    public static boolean[] flatten(boolean[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new boolean[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        boolean[] dst = new boolean[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static boolean[] flatten(boolean[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new boolean[0];
        }
        boolean[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new boolean[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        boolean[] dst = new boolean[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            boolean[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static boolean[] flatten(boolean[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new boolean[0];
        }
        boolean[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new boolean[0];
        }
        boolean[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new boolean[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        boolean[] dst = new boolean[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            boolean[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                boolean[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenBoolean(boolean[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            boolean[] oneDimSrc = (boolean[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenBoolean(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static double[] flatten(double src) {
        boolean stride_0 = true;
        double[] dst = new double[]{src};
        return dst;
    }

    public static double[] flatten(double[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new double[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        double[] dst = new double[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static double[] flatten(double[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new double[0];
        }
        double[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new double[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        double[] dst = new double[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            double[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static double[] flatten(double[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new double[0];
        }
        double[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new double[0];
        }
        double[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new double[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        double[] dst = new double[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            double[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                double[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenDouble(double[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            double[] oneDimSrc = (double[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenDouble(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static short[] flatten(short src) {
        boolean stride_0 = true;
        short[] dst = new short[]{src};
        return dst;
    }

    public static short[] flatten(short[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new short[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        short[] dst = new short[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static short[] flatten(short[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new short[0];
        }
        short[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new short[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        short[] dst = new short[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            short[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static short[] flatten(short[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new short[0];
        }
        short[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new short[0];
        }
        short[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new short[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        short[] dst = new short[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            short[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                short[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenShort(short[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            short[] oneDimSrc = (short[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenShort(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static int[] flatten(int src) {
        boolean stride_0 = true;
        int[] dst = new int[]{src};
        return dst;
    }

    public static int[] flatten(int[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new int[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int[] dst = new int[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static int[] flatten(int[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new int[0];
        }
        int[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new int[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int[] dst = new int[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            int[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static int[] flatten(int[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new int[0];
        }
        int[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new int[0];
        }
        int[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new int[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        int[] dst = new int[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            int[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                int[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenInt(int[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            int[] oneDimSrc = (int[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenInt(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static char[] flatten(String src) {
        return src.toCharArray();
    }

    public static String[] flatten(String[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new String[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        String[] dst = new String[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static String[] flatten(String[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new String[0];
        }
        String[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new String[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        String[] dst = new String[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            String[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static String[] flatten(String[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new String[0];
        }
        String[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new String[0];
        }
        String[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new String[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        String[] dst = new String[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            String[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                String[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangString(String[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            String[] oneDimSrc = (String[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangString(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static int[] flatten(Integer src) {
        boolean stride_0 = true;
        int[] dst = new int[]{src};
        return dst;
    }

    public static int[] flatten(Integer[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new int[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int[] dst = new int[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static int[] flatten(Integer[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new int[0];
        }
        Integer[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new int[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int[] dst = new int[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Integer[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static int[] flatten(Integer[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new int[0];
        }
        Integer[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new int[0];
        }
        Integer[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new int[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        int[] dst = new int[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Integer[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                Integer[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangInteger(int[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            Integer[] oneDimSrc = (Integer[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangInteger(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static byte[] flatten(byte src) {
        boolean stride_0 = true;
        byte[] dst = new byte[]{src};
        return dst;
    }

    public static byte[] flatten(byte[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new byte[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        byte[] dst = new byte[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static byte[] flatten(byte[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new byte[0];
        }
        byte[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new byte[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        byte[] dst = new byte[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            byte[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static byte[] flatten(byte[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new byte[0];
        }
        byte[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new byte[0];
        }
        byte[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new byte[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        byte[] dst = new byte[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            byte[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                byte[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenByte(byte[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            byte[] oneDimSrc = (byte[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenByte(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static double[] flatten(Double src) {
        boolean stride_0 = true;
        double[] dst = new double[]{src};
        return dst;
    }

    public static double[] flatten(Double[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new double[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        double[] dst = new double[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static double[] flatten(Double[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new double[0];
        }
        Double[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new double[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        double[] dst = new double[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Double[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static double[] flatten(Double[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new double[0];
        }
        Double[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new double[0];
        }
        Double[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new double[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        double[] dst = new double[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Double[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                Double[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangDouble(double[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            Double[] oneDimSrc = (Double[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangDouble(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static boolean[] flatten(Boolean src) {
        boolean stride_0 = true;
        boolean[] dst = new boolean[]{src};
        return dst;
    }

    public static boolean[] flatten(Boolean[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new boolean[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        boolean[] dst = new boolean[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static boolean[] flatten(Boolean[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new boolean[0];
        }
        Boolean[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new boolean[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        boolean[] dst = new boolean[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Boolean[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static boolean[] flatten(Boolean[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new boolean[0];
        }
        Boolean[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new boolean[0];
        }
        Boolean[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new boolean[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        boolean[] dst = new boolean[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Boolean[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                Boolean[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangBoolean(boolean[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            Boolean[] oneDimSrc = (Boolean[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangBoolean(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static long[] flatten(Long src) {
        boolean stride_0 = true;
        long[] dst = new long[]{src};
        return dst;
    }

    public static long[] flatten(Long[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new long[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        long[] dst = new long[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static long[] flatten(Long[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new long[0];
        }
        Long[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new long[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        long[] dst = new long[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Long[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static long[] flatten(Long[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new long[0];
        }
        Long[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new long[0];
        }
        Long[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new long[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        long[] dst = new long[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            Long[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                Long[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenJavaLangLong(long[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            Long[] oneDimSrc = (Long[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenJavaLangLong(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }

    public static float[] flatten(float src) {
        boolean stride_0 = true;
        float[] dst = new float[]{src};
        return dst;
    }

    public static float[] flatten(float[] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new float[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        float[] dst = new float[stride_1];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            dst[start_0] = src[i0];
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static float[] flatten(float[][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new float[0];
        }
        float[] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new float[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        float[] dst = new float[stride_2];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            float[] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                dst[start_1] = src_i0[i1];
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static float[] flatten(float[][][] src) {
        int len0 = src.length;
        if (0 == len0) {
            return new float[0];
        }
        float[][] src_0 = src[0];
        int len1 = src_0.length;
        if (0 == len1) {
            return new float[0];
        }
        float[] src_0_0 = src_0[0];
        int len2 = src_0_0.length;
        if (0 == len2) {
            return new float[0];
        }
        boolean stride_0 = true;
        int stride_1 = 1 * len0;
        int stride_2 = stride_1 * len1;
        int stride_3 = stride_2 * len2;
        float[] dst = new float[stride_3];
        int i0 = 0;
        int start_0 = 0;
        while (i0 < len0) {
            float[][] src_i0 = src[i0];
            int i1 = 0;
            int start_1 = start_0;
            while (i1 < len1) {
                float[] src_i0_i1 = src_i0[i1];
                int i2 = 0;
                int start_2 = start_1;
                while (i2 < len2) {
                    dst[start_2] = src_i0_i1[i2];
                    ++i2;
                    start_2 += stride_2;
                }
                ++i1;
                start_1 += stride_1;
            }
            ++i0;
            ++start_0;
        }
        return dst;
    }

    public static void genericFlattenFloat(float[] dst, Object src, int start, List<Integer> stride, List<Integer> len, int depth) {
        if (depth == 1) {
            float[] oneDimSrc = (float[])src;
            int ln = len.get(0);
            int st = stride.get(0);
            int i = 0;
            while (i < ln) {
                dst[start] = oneDimSrc[i];
                ++i;
                start += st;
            }
        } else {
            Object[] multiDimSrc = (Object[])src;
            --depth;
            int stride0 = stride.get(0);
            int len0 = len.get(0);
            List<Integer> subStride = stride.subList(1, stride.size());
            List<Integer> subLen = len.subList(1, len.size());
            int i = 0;
            while (i < len0) {
                Flattener.genericFlattenFloat(dst, multiDimSrc[i], start, subStride, subLen, depth);
                ++i;
                start += stride0;
            }
        }
    }
}

