/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.annotations.MWStructureList;
import com.mathworks.mps.client.internal.ArrayUtils;
import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryConstructor;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryMaker;
import com.mathworks.mps.client.internal.MWStructToBeanFactorySetter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class InterfaceValidator {
    private static final Collection<Class<? extends Exception>> requiredExceptions = Collections.unmodifiableCollection(Arrays.asList(IOException.class, MATLABException.class));
    private static final String requiredExceptionsString = requiredExceptions.toString().replaceAll("class", "");
    private static final Collection<Class> supportedJavaTypes = InterfaceValidator.initializeSupportedJavaTypesSet();

    private static Collection<Class> initializeSupportedJavaTypesSet() {
        HashSet<Class> types = new HashSet<Class>();
        types.add(Byte.TYPE);
        types.add(Byte.class);
        types.add(Short.TYPE);
        types.add(Short.class);
        types.add(Integer.TYPE);
        types.add(Integer.class);
        types.add(Long.TYPE);
        types.add(Long.class);
        types.add(Float.TYPE);
        types.add(Float.class);
        types.add(Double.TYPE);
        types.add(Double.class);
        types.add(Character.TYPE);
        types.add(Character.class);
        types.add(Boolean.TYPE);
        types.add(Boolean.class);
        types.add(String.class);
        types.add(Object.class);
        types.add(Void.TYPE);
        return Collections.unmodifiableSet(types);
    }

    public static void validateInterface(Class mwComponent) {
        ArrayList<Class> structInputTypesCache = new ArrayList<Class>();
        ArrayList<Class> structOutputTypesCache = new ArrayList<Class>();
        Collection<Class> structTypesInterface = InterfaceValidator.getMWStructListAnnotationValue(mwComponent);
        InterfaceValidator.validateStructAnnotation(structTypesInterface, structInputTypesCache, structOutputTypesCache);
        Method[] compMethods = mwComponent.getDeclaredMethods();
        if (compMethods.length == 0) {
            throw new IllegalArgumentException("Interface must have at least one method");
        }
        for (Method method : compMethods) {
            Class<?>[] inputs;
            if (!InterfaceValidator.throwsAllCheckedExceptions(method)) {
                String detailedMsg = "Method \"" + method.getName() + "\" and all the other methods of interface \"" + mwComponent.getName() + "\" must throw following checked exceptions :\n" + requiredExceptionsString + "\n";
                throw new IllegalArgumentException(detailedMsg);
            }
            Collection<Class> structTypesMethod = InterfaceValidator.getMWStructListAnnotationValue(method);
            InterfaceValidator.validateStructAnnotation(structTypesMethod, structInputTypesCache, structOutputTypesCache);
            structTypesMethod.addAll(structTypesInterface);
            for (Class<?> inputType : inputs = method.getParameterTypes()) {
                if (InterfaceValidator.isValidAsInputParameter(inputType, structTypesMethod, structInputTypesCache)) continue;
                throw new IllegalArgumentException(InterfaceValidator.getErrorMsgForInvalidInputs(inputType.getName(), method.getName(), method.getDeclaringClass().getName()));
            }
            if (InterfaceValidator.isValidAsOutputParameter(method.getReturnType(), structTypesMethod, structOutputTypesCache)) continue;
            throw new IllegalArgumentException(InterfaceValidator.getErrorMsgForInvalidOutput(method.getName(), method.getDeclaringClass().getName()));
        }
    }

    private static boolean throwsAllCheckedExceptions(Method method) {
        Class[] actExceptions = method.getExceptionTypes();
        if (actExceptions.length == 0) {
            return false;
        }
        for (Class<? extends Exception> reqException : requiredExceptions) {
            if (InterfaceValidator.isAssignableFrom(actExceptions, reqException)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidAsInputParameter(Class type, Collection<Class> structTypes, List<Class> structInputTypesCache) {
        Class inputTypeScalar = ArrayUtils.getArrayElementType(type);
        return supportedJavaTypes.contains(inputTypeScalar) || structTypes.contains(inputTypeScalar) && InterfaceValidator.isValidInputAsStructure(inputTypeScalar, structInputTypesCache);
    }

    private static boolean isValidAsOutputParameter(Class type, Collection<Class> structTypes, List<Class> structOutputTypesCache) {
        Class inputTypeScalar = ArrayUtils.getArrayElementType(type);
        return supportedJavaTypes.contains(inputTypeScalar) || structTypes.contains(inputTypeScalar) && InterfaceValidator.isValidOutputAsStructure(inputTypeScalar, structOutputTypesCache);
    }

    private static void validateStructAnnotation(Collection<Class> structTypes, List<Class> structInputTypesCache, List<Class> structOutputTypesCache) {
        for (Class cls : structTypes) {
            InterfaceValidator.throwIfArrayType(cls);
            if (InterfaceValidator.isValidInputAsStructure(cls, structInputTypesCache) || InterfaceValidator.isValidOutputAsStructure(cls, structOutputTypesCache)) continue;
            throw new IllegalArgumentException(InterfaceValidator.getErrorMsgForInvalidAnnotation(cls.getName()));
        }
    }

    private static boolean isValidInputAsStructure(Class input, List<Class> structInputTypesCache) {
        if (structInputTypesCache.contains(input)) {
            return true;
        }
        Collection<Class> structListClass = InterfaceValidator.getMWStructListAnnotationValue(input);
        int numPropsWithGetMethod = 0;
        try {
            BeanInfo bInfo = Introspector.getBeanInfo(input, Object.class);
            PropertyDescriptor[] pDesc = bInfo.getPropertyDescriptors();
            if (pDesc == null || pDesc.length == 0) {
                return false;
            }
            for (PropertyDescriptor p : pDesc) {
                Method getter = p.getReadMethod();
                if (getter == null) continue;
                if (!structInputTypesCache.contains(input)) {
                    structInputTypesCache.add(input);
                }
                Collection<Class> structListGetterProp = InterfaceValidator.getMWStructListAnnotationValue(getter);
                structListGetterProp.addAll(structListClass);
                if (!InterfaceValidator.isValidAsInputParameter(p.getPropertyType(), structListGetterProp, structInputTypesCache)) {
                    return false;
                }
                ++numPropsWithGetMethod;
            }
        }
        catch (IntrospectionException ex) {
            return false;
        }
        return numPropsWithGetMethod > 0;
    }

    private static boolean isValidOutputAsStructure(Class output, List<Class> structOutputTypesCache) {
        if (structOutputTypesCache.contains(output)) {
            return true;
        }
        Collection<Class> structListClass = InterfaceValidator.getMWStructListAnnotationValue(output);
        List<MWStructToBeanFactory> factoryList = MWStructToBeanFactoryMaker.createFactoryList(output);
        if (factoryList.size() == 0) {
            return false;
        }
        for (MWStructToBeanFactory structToBeanFactory : factoryList) {
            if (!structOutputTypesCache.contains(output)) {
                structOutputTypesCache.add(output);
            }
            if (structToBeanFactory instanceof MWStructToBeanFactorySetter) {
                Map<String, Method> setterMap = ((MWStructToBeanFactorySetter)structToBeanFactory).getBeanSetterMap();
                Collection<Method> setters = setterMap.values();
                for (Method setter : setters) {
                    Collection<Class> structListSetterProp = InterfaceValidator.getMWStructListAnnotationValue(setter);
                    structListSetterProp.addAll(structListClass);
                    if (InterfaceValidator.isValidAsOutputParameter(setter.getParameterTypes()[0], structListSetterProp, structOutputTypesCache)) continue;
                    return false;
                }
                continue;
            }
            if (!(structToBeanFactory instanceof MWStructToBeanFactoryConstructor)) continue;
            Constructor constr = ((MWStructToBeanFactoryConstructor)structToBeanFactory).getBeanConstructor();
            Collection<Class> structListConstructor = InterfaceValidator.getMWStructListAnnotationValue(constr);
            structListConstructor.addAll(structListClass);
            Collection<Class> constrParamsTypes = structToBeanFactory.getAllPropTypes();
            for (Class constrParamType : constrParamsTypes) {
                if (InterfaceValidator.isValidAsOutputParameter(constrParamType, structListConstructor, structOutputTypesCache)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isAssignableFrom(Class[] actExceptions, Class reqException) {
        boolean status = false;
        for (Class actException : actExceptions) {
            if (!actException.isAssignableFrom(reqException)) continue;
            status = true;
            break;
        }
        return status;
    }

    private static Collection<Class> getMWStructListAnnotationValue(Object cls) {
        HashSet<Class> structSet = new HashSet<Class>();
        MWStructureList annotation = null;
        if (cls instanceof Class) {
            annotation = ((Class)cls).getAnnotation(MWStructureList.class);
        } else if (cls instanceof Method) {
            annotation = ((Method)cls).getAnnotation(MWStructureList.class);
        } else if (cls instanceof Constructor) {
            annotation = ((Constructor)cls).getAnnotation(MWStructureList.class);
        }
        if (annotation != null) {
            structSet.addAll(Arrays.asList(annotation.value()));
        }
        return structSet;
    }

    private static void throwIfArrayType(Class cls) {
        if (cls.isArray()) {
            throw new IllegalArgumentException("Found an invalid type in MWStructureList annotation : " + cls.getName() + ". Only scalar types are allowed.");
        }
    }

    private static String getErrorMsgForInvalidInputs(String inputType, String methodName, String interfaceName) {
        return String.format("One of the types, %s, found during analysis of inputs of method, %s, of interface, %s, is unsupported.\nThe declared type of input must be either a Java primitive or boxed type, or String or Object. If it is a user defined class to represent\na MATLAB structure, it must fulfill following:\n1. It must be included in the MWStructureList annotation of either the method or the interface\n2. It must have at least one property with a public get method to retrieve its value\n3. The declared types of these properties must be valid\nPlease refer the javadoc for more information on supported types", inputType, methodName, interfaceName);
    }

    private static String getErrorMsgForInvalidOutput(String methodName, String interfaeName) {
        return String.format("The return type of method, %s, of interface, %s, is unsupported.\nThe declared type of output must be either a Java primitive, boxed type, String or Object. If it is a user defined class to represent\na MATLAB structure, it must fulfill following:\n1. It must be included in the MWStructureList annotation of either the interface or the method\n2. It must have at least one property representing a field of a MATLAB structure\n3. It must have a public default constructor and public set methods for its properties or a public constructor that initializes all the \n   properties and has @ConstructorProperties annotation\n4. A default (no-argument) constructor needs to be explicitly defined only if there is a user defined overloaded constructor provided for this type\n5. The declared types of these properties must be valid\n6. If the declared type of one of the properties of this class is representing a MATLAB struct, it must be included in the\n   MWStructureList annotation provided for the class or for the set method for the property or for the constructor with the @ConstructorProperties annotation.\nPlease refer the javadoc for more information on supported types", methodName, interfaeName);
    }

    private static String getErrorMsgForInvalidAnnotation(String typeName) {
        return String.format("One of the members, %s, of MWStructureList annotation, is unsupported and\ncannot be used for marshaling a MATLAB structure either as input or output.\n\nTo be a valid input MATLAB structure, a java class must fulfill following:\n1. It must have at least one property with a public get method to retrieve its value\n2. The declared types of these properties must be valid\n3. If the declared type of one of the properties of this class is representing a MATLAB struct, it must be included in the\n   MWStructureList annotation provided for the class or for the get method for the property.\n\nTo be a valid output MATLAB structure, a java class must fulfill following:\n1. It must have at least one property representing a field of a MATLAB structure\n2. It must have a public default constructor and public set methods for its properties or a public constructor that initializes all the \n   properties and has @ConstructorProperties annotation\n3. The declared types of these properties must be valid\n4. If the declared type of one of the properties of this class is representing a MATLAB struct, it must be included in the\n   MWStructureList annotation provided for the class or for the set method for the property or for the constructor with the @ConstructorProperties annotation.\nPlease refer the javadoc for more information on supported types", typeName);
    }
}

