/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.google.protobuf.ExtensionRegistry;
import com.mathworks.mps.client.MATLABStackFrame;
import com.mathworks.mps.client.MWSSLConfig;
import com.mathworks.mps.client.MWSSLServerAuthorizer;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MATLABArrayFactory;
import com.mathworks.mps.client.internal.MATLABError;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLException;

public class MWInvocationHandlerUtils {
    static ExtensionRegistry extRegistry = ExtensionRegistry.newInstance();

    public static MATLABParams.MATLAB_Params createMATLABParams(int nargout, Object[] inputs, MWAttributesContainer mwAttributesContainer) {
        if (nargout < 0) {
            throw new IllegalArgumentException("For a method with Object[] as output type and first input of type int,\nthe first input value is always treated as number of outputs from the \ncorresponding MATLAB function and not as one of the inputs for it.\nNumber of outputs for a MATLAB function must be greater than 0.");
        }
        MATLABParams.MATLAB_Params.Builder mlParams = MATLABParams.MATLAB_Params.newBuilder();
        mlParams.setNargout(nargout);
        MWInvocationHandlerUtils.updateMATLABParamsWithFuncInputs(mlParams, inputs, mwAttributesContainer);
        return mlParams.build();
    }

    private static void updateMATLABParamsWithFuncInputs(MATLABParams.MATLAB_Params.Builder mlParams, Object[] funcInputs, MWAttributesContainer mwAttributesContainer) {
        if (funcInputs != null) {
            for (Object input : funcInputs) {
                mlParams.addRhs(MATLABArrayFactory.newInstance(input, mwAttributesContainer));
            }
        }
    }

    public static List<MATLABStackFrame> convertToMATLABStackFrameList(List<MATLABError.MATLAB_Error.Stack_Frame> protoStack) {
        ArrayList<MATLABStackFrame> mlStackList = new ArrayList<MATLABStackFrame>();
        for (MATLABError.MATLAB_Error.Stack_Frame fr : protoStack) {
            mlStackList.add(new MATLABStackFrame(fr.getFile(), fr.getName(), fr.getLine()));
        }
        return Collections.unmodifiableList(mlStackList);
    }

    public static void throwIfServerIsNotAuthorized(Certificate[] serverCerts, MWSSLConfig sslConfig) throws SSLException {
        MWSSLServerAuthorizer serverAuthorizer = sslConfig.getServerAuthorizer();
        if (serverAuthorizer != null) {
            if (serverCerts.length > 0) {
                if (!serverAuthorizer.authorize(serverCerts[0])) {
                    throw new SSLException("MPS client failed to authorize the server.");
                }
            } else if (serverAuthorizer.isCertificateRequired()) {
                throw new SSLException("MPS client failed to authorize the server because it did not receive a certificate from server");
            }
        }
    }

    static {
        MATLABArray.registerAllExtensions(extRegistry);
    }
}

