/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWHttpClientConfig;
import com.mathworks.mps.client.MWHttpException;
import com.mathworks.mps.client.MWRequest;
import com.mathworks.mps.client.MWRequestListener;
import com.mathworks.mps.client.MWSSLConfig;
import com.mathworks.mps.client.internal.AbstractHttpClientFevalHandler;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import com.mathworks.mps.client.internal.MWSSLContext;
import com.mathworks.mps.client.internal.ResponseProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;

public class SunHttpClientFevalHandler
extends AbstractHttpClientFevalHandler {
    private final MWSSLConfig sslConfig;
    private final int connectTimeOutMs;
    private final int readTimeOutMs;
    private final SSLSocketFactory sslSocketFactory;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());

    public SunHttpClientFevalHandler(MWHttpClientConfig clientConfig, MWSSLConfig sslConfig) {
        super(clientConfig.getResponseSizeLimit());
        this.LOG.debug("Initializing Sun HTTP feval handler");
        this.sslConfig = sslConfig;
        this.readTimeOutMs = this.connectTimeOutMs = new Long(clientConfig.getTimeOutMs()).intValue();
        try {
            this.sslSocketFactory = sslConfig.getSSLContext() == null ? MWSSLContext.getDefault().getSocketFactory() : sslConfig.getSSLContext().getSocketFactory();
        }
        catch (Exception ex) {
            throw new RuntimeException("Trouble initializing MWHttpClient", ex);
        }
        this.LOG.debug("Sun HTTP feval handler initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MATLABResult.MATLAB_Result processRequest(URL url, MATLABParams.MATLAB_Params mlParams) throws Throwable {
        MATLABResult.MATLAB_Result mATLAB_Result;
        this.LOG.debug("Processing request (sync)");
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("POST");
        urlConnection.setRequestProperty("User-Agent", this.getClass().getName());
        urlConnection.setRequestProperty("Content-Type", "application/x-google-protobuf");
        urlConnection.setDoOutput(true);
        urlConnection.setUseCaches(true);
        urlConnection.setConnectTimeout(this.connectTimeOutMs);
        urlConnection.setReadTimeout(this.readTimeOutMs);
        boolean isHTTPS = this.isSecureConnection(url);
        if (isHTTPS) {
            HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)urlConnection;
            httpsUrlConnection.setSSLSocketFactory(this.sslSocketFactory);
            HostnameVerifier hostnameVerifier = this.sslConfig.getHostnameVerifier();
            if (hostnameVerifier != null) {
                httpsUrlConnection.setHostnameVerifier(hostnameVerifier);
            }
        }
        this.LOG.trace("Sending request (sync)");
        this.LOG.trace("Execute POST - {}", urlConnection);
        urlConnection.connect();
        if (isHTTPS) {
            try {
                MWInvocationHandlerUtils.throwIfServerIsNotAuthorized(((HttpsURLConnection)urlConnection).getServerCertificates(), this.sslConfig);
            }
            catch (Exception ex) {
                urlConnection.disconnect();
                throw ex;
            }
        }
        try (OutputStream oStream = urlConnection.getOutputStream();){
            mlParams.writeTo(oStream);
            oStream.flush();
        }
        InputStream iStream = urlConnection.getInputStream();
        CodedInputStream iStreamCoded = CodedInputStream.newInstance(iStream);
        iStreamCoded.setSizeLimit(this.responseSizeLimit);
        try {
            this.LOG.trace("HTTP RESPONSE --------- completed: {}", (Object)urlConnection.getResponseMessage());
            mATLAB_Result = MATLABResult.MATLAB_Result.parseFrom(iStreamCoded, (ExtensionRegistryLite)MWInvocationHandlerUtils.extRegistry);
        }
        catch (Throwable throwable) {
            try {
                iStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                int respCode = urlConnection.getResponseCode();
                if (respCode == 200) {
                    throw ex;
                }
                throw new MWHttpException(respCode, urlConnection.getResponseMessage());
            }
        }
        iStream.close();
        return mATLAB_Result;
    }

    @Override
    public <T> MWRequest<T> processRequest(URL url, MATLABParams.MATLAB_Params mlParams, ResponseProducer<T> builder, MWRequestListener<T> callback) {
        return null;
    }

    @Override
    public void abort() {
    }
}

