/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.RequestLine;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.apache.http.message.BasicHeaderElementIterator;
import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.MWHttpException;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.MATLABRequestCreated;
import com.mathworks.mps.client.internal.MATLABRequestInfo;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.ResponseProducer;
import com.mathworks.mps.client.internal.async.FailedMWRequestState;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import com.mathworks.mps.client.internal.async.MWRequestInfo;
import com.mathworks.mps.client.internal.async.ReadyMWRequestState;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;

public class HttpResponseCallback<T>
implements FutureCallback<HttpResponse> {
    private final String serverUri;
    private final MWRequestInfo<T> clientRequestInfo;
    private MWRequestImpl<T> request;
    private final ApacheHttpClient httpClient;
    private final Logger LOG;
    private HttpClientContext httpContext;

    public HttpResponseCallback(String serverURI, MWRequestImpl<T> request, ApacheHttpClient httpClient, HttpClientContext httpContext) {
        this.request = request;
        this.clientRequestInfo = request.getClientRequestInfo();
        this.httpClient = httpClient;
        this.serverUri = serverURI;
        this.LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());
        this.httpContext = httpContext;
    }

    @Override
    public void cancelled() {
        this.LOG.trace("Request cancelled: {}", this.httpContext.getRequest().getRequestLine());
        this.httpClient.getClientUsageLock().usageExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void completed(HttpResponse response) {
        int responseCode = response.getStatusLine().getStatusCode();
        try {
            if (responseCode == 200) {
                try {
                    Object object = this.request.lock;
                    synchronized (object) {
                        if (this.request.markedForCancellation) {
                            return;
                        }
                    }
                    ResponseProducer<T> builder = this.clientRequestInfo.getResponseBuilder();
                    MATLABResult.MATLAB_Result mlResult = this.httpClient.parseMATLABResult(response);
                    builder.checkMLResultForErrors(mlResult);
                    Object responseData = builder.createMATLABResponse(mlResult);
                    this.LOG.debug("Received MATLAB result for request: {}", (Object)this.request.getClientRequestInfo().getRequestUrl());
                    this.request.updateStateAndNotify(new ReadyMWRequestState<Object>(responseData, this.clientRequestInfo));
                    return;
                }
                catch (IOException ex) {
                    this.request.updateStateAndNotify(new FailedMWRequestState(ex));
                    return;
                }
                catch (MATLABException ex) {
                    this.request.updateStateAndNotify(new FailedMWRequestState(ex));
                    return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (Exception ex2) {
                        this.request.updateStateAndNotify(new FailedMWRequestState(ex2));
                        return;
                    }
                }
                finally {
                    String requestUrl = this.request.getClientRequestInfo().getRequestUrl();
                    this.LOG.trace("Deleting request since it has reached terminal state: {}", (Object)requestUrl);
                    if (requestUrl != null) {
                        String sessionID = this.request.getClientRequestInfo().getInstance().getSessionId();
                        this.httpClient.requestsCreated.get(sessionID).remove(requestUrl);
                    } else {
                        this.httpClient.pendingRequests.remove(this.request.getTempId());
                    }
                }
            }
            if (responseCode == 201) {
                if (this.httpClient.getClientUsageLock().wasAttemptedToClose()) {
                    return;
                }
                this.httpClient.pendingRequests.remove(this.request.getTempId());
                {
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                BasicHeaderElementIterator iterStartTime = new BasicHeaderElementIterator(response.headerIterator("X-MPS-Start-Time"));
                String mps_session_id = "";
                if (iterStartTime.hasNext()) {
                    mps_session_id = iterStartTime.nextElement().getName();
                }
                BasicHeaderElementIterator iter = new BasicHeaderElementIterator(response.headerIterator("Location"));
                String requestUrl = iter.nextElement().getName();
                UUID instanceUuid = this.parseInstanceUUID(requestUrl);
                MATLABRequestCreated.MATLAB_Request_Created requestCreated = this.httpClient.parseMATLABRequest(response);
                MWRequestInfo<T> clientRequestInfo = this.request.getClientRequestInfo();
                clientRequestInfo.setSubscriptionURL(requestCreated.getSubscriptionUrl());
                clientRequestInfo.setRequestUrl(requestUrl);
                this.httpClient.registerRequest(this.request, instanceUuid, this.serverUri, mps_session_id, this.httpContext);
                Object object = this.request.lock;
                synchronized (object) {
                    if (this.request.markedForCancellation) {
                        this.request.sendCancelRequest();
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 16, 28, 13] lbl67 : MonitorExitStatement: MONITOREXIT : var10_28
                    MATLABRequestInfo.MATLAB_Request_Info createdInfo = requestCreated.getInfo();
                    MATLABRequestInfo.MATLAB_Request_Info notificationsInfo = this.httpClient.pendingNotifications.remove(requestUrl);
                    MATLABRequestInfo.MATLAB_Request_Info serverRequestInfo = notificationsInfo == null ? createdInfo : notificationsInfo;
                    this.httpClient.updateRequest(requestUrl, serverRequestInfo, mps_session_id);
                    return;
                }
            }
            this.request.updateStateAndNotify(new FailedMWRequestState(new MWHttpException(responseCode, response.getStatusLine().getReasonPhrase())));
            return;
        }
        finally {
            this.httpClient.getClientUsageLock().usageExit();
        }
    }

    private UUID parseInstanceUUID(String location) {
        String[] instance = location.split("/");
        return UUID.fromString(instance[1].substring(1));
    }

    @Override
    public void failed(Exception ex) {
        if (this.httpContext.getRequest() != null) {
            RequestLine reqLine = this.httpContext.getRequest().getRequestLine();
            this.LOG.trace("Request failed: {}", (Object)(reqLine.getMethod() + " " + this.serverUri + reqLine.getUri()));
        }
        this.httpClient.getClientUsageLock().usageExit();
        this.request.updateStateAndNotify(new FailedMWRequestState(ex));
    }
}

