/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;

public class MWFuture<T>
implements Future<T> {
    static final int RUNNING = 0;
    static final int COMPLETED = 1;
    static final int CANCELLED = 2;
    static final int INTERRUPTED = 3;
    public final Object lock = new Object();
    private MWRequestImpl<T> request;
    private int state;
    private T response = null;
    private CancellationException cancelException;
    private ExecutionException execException;
    private InterruptedException interruptException;
    public Boolean finished = false;
    public final boolean markedForCancellation = false;
    private final Logger LOG;

    public MWFuture(MWRequestImpl<T> request) {
        this.request = request;
        this.LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());
    }

    public void setState(int newState) {
        this.state = newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws ExecutionException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.LOG.trace("MWFuture get: wait loop entry, for request: {}", (Object)this.request.getRequestURL());
            while (!this.finished.booleanValue()) {
                this.lock.wait();
            }
            this.LOG.trace("MWFuture get: wait loop exit, for request: {}", (Object)this.request.getRequestURL());
        }
        return this.getValue();
    }

    @Override
    public boolean isCancelled() {
        return this.state == 2;
    }

    private T getValue() throws CancellationException, ExecutionException, InterruptedException {
        switch (this.state) {
            case 2: {
                throw this.cancelException;
            }
            case 3: {
                throw this.interruptException;
            }
            case 1: {
                if (this.execException != null) {
                    throw this.execException;
                }
                return this.response;
            }
        }
        throw new IllegalStateException("Get the right error message");
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.request.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long startTime = System.currentTimeMillis();
        long timeoutms = unit.toMillis(timeout);
        long waitUntil = startTime + unit.toMillis(timeout);
        Object object = this.lock;
        synchronized (object) {
            this.LOG.trace("MWFuture get: wait loop entry");
            while (!this.finished.booleanValue() && System.currentTimeMillis() < waitUntil) {
                this.lock.wait(timeoutms);
                this.LOG.debug("MWFuture get: waited {}ms, finished: {}", timeoutms, (Object)this.finished);
            }
            this.LOG.debug("MWFuture get: wait loop exit, finished: {}", this.finished);
        }
        if (this.finished.booleanValue()) {
            return this.getValue();
        }
        throw new TimeoutException();
    }

    @Override
    public boolean isDone() {
        return this.state == 1 || this.state == 2;
    }

    void set(T responseData) {
        this.response = responseData;
        this.state = 1;
        this.LOG.trace("MWFuture state: COMPLETED, after receiving result for request: {}", (Object)this.request.getRequestURL());
    }

    void setCancelException(CancellationException t) {
        this.cancelException = t;
        this.state = 2;
        this.LOG.trace("MWFuture state: CANCELLED, for request:{}", (Object)this.request.getRequestURL());
    }

    void setInterruptedException(InterruptedException t) {
        this.interruptException = t;
        this.state = 3;
        this.LOG.trace("MWFuture state: INTERRUPTED for request:{}", (Object)this.request.getRequestURL());
    }

    void setExecException(ExecutionException t) {
        this.execException = t;
        this.state = 1;
        this.LOG.trace("MWFuture state: COMPLETED with exception, for request:{}", (Object)this.request.getRequestURL());
    }
}

