/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MWClient;
import com.mathworks.mps.client.MWInvokable;
import com.mathworks.mps.client.MWMarshalingRules;
import com.mathworks.mps.client.annotations.MWStructureList;
import com.mathworks.mps.client.internal.AbstractMethodDispatcher;
import com.mathworks.mps.client.internal.MWMethodDispatcher;
import com.mathworks.mps.client.internal.NargoutDispatcher;
import com.mathworks.mps.client.internal.SingleOutputDispatcher;
import com.mathworks.mps.client.internal.VoidOutputDispatcher;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IdentifyDispatcher {
    public static Map<Method, MWMethodDispatcher> buildMethodToDispatcherMap(URL url, Class mwComponent, MWClient client) {
        List<Class> mwInterfaceStructList = IdentifyDispatcher.getInterfaceStructAttribute(mwComponent);
        Method[] compMethods = mwComponent.getDeclaredMethods();
        HashMap<Method, AbstractMethodDispatcher> methodDispatcherTable = new HashMap<Method, AbstractMethodDispatcher>();
        for (Method method : compMethods) {
            List<Class> mwMethodStructList = IdentifyDispatcher.getMethodStructAttribute(method);
            MWMarshalingRules mwMarshalingRules = IdentifyDispatcher.createMarshalingRules(mwInterfaceStructList, mwMethodStructList);
            MWInvokable invokable = client.createComponentProxy(url, mwMarshalingRules);
            boolean hasNargout = IdentifyDispatcher.checkForNargout(method);
            boolean withVarArgs = method.isVarArgs();
            if (hasNargout) {
                methodDispatcherTable.put(method, new NargoutDispatcher(method.getName(), invokable, withVarArgs));
                continue;
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                methodDispatcherTable.put(method, new VoidOutputDispatcher(method.getName(), invokable, withVarArgs));
                continue;
            }
            methodDispatcherTable.put(method, new SingleOutputDispatcher(method.getName(), method.getReturnType(), invokable, withVarArgs));
        }
        return Collections.unmodifiableMap(methodDispatcherTable);
    }

    private static MWMarshalingRules createMarshalingRules(List<Class> mwInterfaceStructList, List<Class> mwMethodStructList) {
        final ArrayList<Class> mwStructList = new ArrayList<Class>(mwInterfaceStructList.size() + mwMethodStructList.size());
        for (Class cls : mwMethodStructList) {
            mwStructList.add(cls);
        }
        for (Class cls : mwInterfaceStructList) {
            mwStructList.add(cls);
        }
        return new MWMarshalingRules(){

            @Override
            public List<Class> getStructTypes() {
                return mwStructList;
            }
        };
    }

    private static List<Class> getInterfaceStructAttribute(Class mwComponent) {
        ArrayList<Class> componentStructList;
        MWStructureList mwInterfaceStructList = mwComponent.getAnnotation(MWStructureList.class);
        ArrayList<Class> arrayList = componentStructList = mwInterfaceStructList != null ? new ArrayList<Class>(mwInterfaceStructList.value().length) : new ArrayList();
        if (mwInterfaceStructList != null) {
            componentStructList.addAll(Arrays.asList(mwInterfaceStructList.value()));
        }
        return Collections.unmodifiableList(componentStructList);
    }

    private static List<Class> getMethodStructAttribute(Method method) {
        ArrayList<Class> methodStructList;
        MWStructureList mwMethodStructList = method.getAnnotation(MWStructureList.class);
        ArrayList<Class> arrayList = methodStructList = mwMethodStructList != null ? new ArrayList<Class>(mwMethodStructList.value().length) : new ArrayList();
        if (mwMethodStructList != null) {
            methodStructList.addAll(Arrays.asList(mwMethodStructList.value()));
        }
        return Collections.unmodifiableList(methodStructList);
    }

    private static boolean checkForNargout(Method m) {
        Class<?> retType = m.getReturnType();
        Class<?>[] paramTypes = m.getParameterTypes();
        return retType.equals(Object[].class) && paramTypes.length > 0 && paramTypes[0] == Integer.TYPE;
    }
}

