/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.internal.JavaDataExtractor;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MATLABError;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import java.util.List;

public class ResponseProducer<T> {
    private final int nargout;
    private final Class<T> targetType;
    private final boolean hasNargout;
    private final MWAttributesContainer attributesContainer;
    private final String functionName;

    public ResponseProducer(int nargout, Class<T> targetType, MWAttributesContainer attributesContainer, String functionName, boolean hasNargout) {
        this.nargout = nargout;
        this.targetType = targetType;
        this.attributesContainer = attributesContainer;
        this.functionName = functionName;
        this.hasNargout = hasNargout;
    }

    public Object createMATLABResponse(MATLABResult.MATLAB_Result mlResult) throws MATLABException {
        List<MATLABArray.MATLAB_Array> mlArrList = mlResult.getLhsList();
        if (mlArrList.size() == 0) {
            return null;
        }
        JavaDataExtractor dataExtractor = new JavaDataExtractor(this.attributesContainer);
        Object[] result = new Object[mlArrList.size()];
        Class marshalAsTargetType = this.hasNargout ? Object.class : this.targetType;
        for (int i = 0; i < mlArrList.size(); ++i) {
            result[i] = dataExtractor.toJavaType(mlArrList.get(i), marshalAsTargetType);
        }
        return this.hasNargout ? result : result[0];
    }

    public void checkMLResultForErrors(MATLABResult.MATLAB_Result mlResult) throws MATLABException {
        if (!mlResult.hasError()) {
            if (mlResult.getLhsCount() != this.nargout) {
                throw new IllegalArgumentException("Incorrect number of outputs returned from MATLAB.\nMATLAB returned " + mlResult.getLhsCount() + " number of outputs,\nMethod ," + this.functionName + ", expected " + this.nargout + " number of outputs.");
            }
        } else {
            MATLABError.MATLAB_Error mlError = mlResult.getError();
            throw new MATLABException(mlError.getMessage(), mlError.getIdentifier(), MWInvocationHandlerUtils.convertToMATLABStackFrameList(mlError.getStackList()));
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

