/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.client.methods.HttpGet;
import com.mathworks.apache.http.client.protocol.HttpClientContext;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.mps.client.internal.async.WaitNotifier;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstanceInfo {
    private final UUID instanceUUID;
    private final String location;
    private String serverUri;
    private String sessionId;
    private volatile long since;
    private volatile FutureCallback<HttpResponse> notificationCallback;
    private WaitNotifier waitNotifier;
    public AtomicBoolean notificationRecent;
    public HttpGet httpGet;
    private HttpClientContext httpContext;
    public final Object lock = new Object();

    public String getServerUri() {
        return this.serverUri;
    }

    public UUID getUuid() {
        return this.instanceUUID;
    }

    public String getLocation() {
        return this.location;
    }

    public long getCurrentSeq() {
        return this.since;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setCurrentSeq(long since) {
        this.since = since;
    }

    public void updateSessionId(String newSessionId) {
        this.sessionId = newSessionId;
    }

    public InstanceInfo(UUID instanceUUID, String serverURI, int since, String sessionId, HttpClientContext httpContext) throws URISyntaxException {
        this.instanceUUID = instanceUUID;
        this.location = serverURI + "/~" + instanceUUID + "/";
        this.serverUri = serverURI;
        this.since = since;
        this.sessionId = sessionId;
        this.notificationRecent = new AtomicBoolean(true);
        this.httpContext = httpContext;
        this.waitNotifier = new WaitNotifier();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo)obj;
        return !(this.instanceUUID == null ? other.instanceUUID != null : !this.instanceUUID.equals(other.instanceUUID));
    }

    public boolean isNotificationRunning() {
        return this.notificationCallback != null;
    }

    public void setNotificationRunningTrue(FutureCallback<HttpResponse> callback) {
        this.notificationCallback = callback;
    }

    public void setNotificationRunningFalse() {
        this.notificationCallback = null;
    }

    public FutureCallback<HttpResponse> getNotificationCallback() {
        return this.notificationCallback;
    }

    public HttpClientContext getHttpContext() {
        return this.httpContext;
    }

    public String toString() {
        return String.format("Server URL: %s, Session ID: %s", this.location, this.sessionId);
    }

    public WaitNotifier getWaitNotifier() {
        return this.waitNotifier;
    }
}

