/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal.async;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.apache.http.message.BasicHeaderElementIterator;
import com.mathworks.mps.client.MWHttpClient;
import com.mathworks.mps.client.internal.ApacheHttpClient;
import com.mathworks.mps.client.internal.MATLABRequestInfo;
import com.mathworks.mps.client.internal.MATLABRequestNotification;
import com.mathworks.mps.client.internal.async.FailedMWRequestState;
import com.mathworks.mps.client.internal.async.InstanceInfo;
import com.mathworks.mps.client.internal.async.MWRequestImpl;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;

public class RequestNotificationsCallback<T>
implements FutureCallback<HttpResponse> {
    private final ApacheHttpClient httpClient;
    private final InstanceInfo instance;
    private final Logger LOG = MWHttpClient.loggerFactory.getLogger(this.getClass());
    private int retryCnt;
    private boolean pollOnUpdateError;

    public RequestNotificationsCallback(InstanceInfo instance, ApacheHttpClient httpClient) {
        this.httpClient = httpClient;
        this.instance = instance;
        this.retryCnt = 0;
        this.pollOnUpdateError = httpClient.getMWClient().getConfig().pollOnUpdateErrorAsync();
    }

    @Override
    public void cancelled() {
        this.LOG.trace("Server state update request cancelled: {}", this.instance.getHttpContext().getRequest().getRequestLine());
        this.instance.setNotificationRunningFalse();
        this.httpClient.getClientUsageLock().usageExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(HttpResponse response) {
        try {
            if (this.httpClient.getClientUsageLock().wasAttemptedToClose()) {
                this.instance.setNotificationRunningFalse();
                return;
            }
            this.retryCnt = 0;
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                String mpsSessionId = "";
                BasicHeaderElementIterator iterStartTime = new BasicHeaderElementIterator(response.headerIterator("X-MPS-Start-Time"));
                if (iterStartTime.hasNext()) {
                    mpsSessionId = iterStartTime.nextElement().getName();
                }
                if (!mpsSessionId.equals(this.instance.getSessionId())) {
                    this.LOG.trace("Server instance session ID was changed - New session ID: {} , Old session ID: {}", (Object)mpsSessionId, (Object)this.instance.getSessionId());
                    this.failAllRequests(new IOException("MPS instance has been restarted"));
                    this.httpClient.requestsCreated.remove(this.instance.getSessionId());
                    this.instance.updateSessionId(mpsSessionId);
                }
                try {
                    MATLABRequestNotification.MATLAB_Request_Notification notification = this.httpClient.parseRequestNotification(response);
                    this.instance.setCurrentSeq(notification.getCurrentTime());
                    List<MATLABRequestNotification.MATLAB_Request_Notification.UpdateInfo> updates = notification.getUpdatedList();
                    this.LOG.debug("Server state updates - Number of requests updated: {}", updates.size());
                    for (MATLABRequestNotification.MATLAB_Request_Notification.UpdateInfo update : updates) {
                        String requestUrl = update.getUrl();
                        MATLABRequestInfo.MATLAB_Request_Info reqInfo = update.getInfo();
                        this.LOG.debug("Request update info - url: {}, last_modified: {}, state: {}", new Object[]{requestUrl, reqInfo.getLastModified(), reqInfo.getState()});
                        this.httpClient.updateRequest(requestUrl, reqInfo, mpsSessionId);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.httpClient.executeGetForNotifications(this.instance);
        }
        catch (URISyntaxException ex) {
            this.failAllRequests(ex);
            this.LOG.trace("Exiting update loop for instance : {}", this.instance);
            this.instance.setNotificationRunningFalse();
        }
        finally {
            this.httpClient.getClientUsageLock().usageExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Exception ex) {
        this.LOG.debug("Server state update request failed: ", ex);
        try {
            if (this.httpClient.getClientUsageLock().wasAttemptedToClose()) {
                this.instance.setNotificationRunningFalse();
                return;
            }
            if (ex instanceof SocketTimeoutException) {
                this.LOG.debug("SocketTimeoutException received. This implies long running MATLAB code. Sending update request immediately.");
            } else if (this.pollOnUpdateError) {
                ++this.retryCnt;
                long waitInterval = (long)(500.0 * Math.pow(2.0, this.retryCnt));
                if (waitInterval > 120000L) {
                    waitInterval = 120000L;
                }
                try {
                    this.LOG.debug("Connectivity issues with server instance. Sleeping for {} ms", waitInterval);
                    this.instance.getWaitNotifier().sleepFor(Duration.ofMillis(waitInterval));
                }
                catch (CancellationException cancelExc) {
                    this.LOG.trace("Update thread's sleep, as part of its wait to reestablish server connectivity, was cancelled.");
                    this.instance.getWaitNotifier().reset();
                }
                catch (InterruptedException intExc) {
                    Thread.currentThread().interrupt();
                    this.LOG.trace("Update thread was interrupted as it was sleeping as part of its wait to reestablish server connectivity.");
                    this.instance.setNotificationRunningFalse();
                    this.httpClient.getClientUsageLock().usageExit();
                    return;
                }
            } else {
                this.failAllRequests(ex);
            }
            this.httpClient.executeGetForNotifications(this.instance);
        }
        catch (URISyntaxException exc) {
            this.failAllRequests(ex);
            this.LOG.trace("Exiting update loop for instance : {}", this.instance);
            this.instance.setNotificationRunningFalse();
        }
        finally {
            this.httpClient.getClientUsageLock().usageExit();
        }
    }

    private void failAllRequests(Exception ex) {
        for (MWRequestImpl request : this.httpClient.requestsCreated.get(this.instance.getSessionId()).values()) {
            this.LOG.trace("Moving request to failed state due to error while seeking request updates : {}", (Object)request.getRequestURL());
            request.updateStateAndNotify(new FailedMWRequestState(ex));
        }
    }
}

