/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.selftest;

import com.google.inject.Inject;
import com.nesscomputing.httpserver.selftest.DefaultSelftest;
import com.nesscomputing.httpserver.selftest.Selftest;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/selftest")
@Produces(value={"application/json"})
public class SelftestResource {
    private Set<Selftest> tests = Collections.emptySet();
    private DefaultSelftest defaultTest;

    @Inject
    SelftestResource() {
    }

    @Inject(optional=true)
    public void setSelftests(Set<Selftest> tests) {
        this.tests = tests;
    }

    @Inject(optional=true)
    public void setDefaultSelftest(DefaultSelftest defaultTest) {
        this.defaultTest = defaultTest;
    }

    @GET
    public Response doSelftest() throws Exception {
        for (Selftest test : this.tests) {
            test.doSelftest();
        }
        if (this.defaultTest != null) {
            return this.defaultTest.doSelftest();
        }
        return Response.ok().build();
    }
}

