/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.xml.exception;

import com.nfbsoftware.exception.NfbCheckedException;
import java.io.Serializable;

public class XmlDocumentCheckedException
extends NfbCheckedException {
    private static final long serialVersionUID = 1L;

    public XmlDocumentCheckedException(Code code, String debugInformation) {
        this(code, new Object[0], debugInformation);
    }

    public XmlDocumentCheckedException(Code code, String debugInformation, int severity) {
        this(code, new Object[0], debugInformation, (Throwable)null, severity);
    }

    public XmlDocumentCheckedException(Code code, Object arg, String debugInformation) {
        this(code, new Object[]{arg}, debugInformation);
    }

    public XmlDocumentCheckedException(Code code, Object[] args, String debugInformation) {
        this(code, args, debugInformation, (Throwable)null, code.getSeverity());
    }

    public XmlDocumentCheckedException(Code code, Object arg, String debugInformation, int severity) {
        this(code, new Object[]{arg}, debugInformation, severity);
    }

    public XmlDocumentCheckedException(Code code, Object[] args, String debugInformation, int severity) {
        this(code, args, debugInformation, (Throwable)null, severity);
    }

    public XmlDocumentCheckedException(Code code, Object arg, String debugInformation, Throwable rootCause) {
        this(code, new Object[]{arg}, debugInformation, rootCause);
    }

    public XmlDocumentCheckedException(Code code, Object[] args, String debugInformation, Throwable rootCause) {
        this(code, args, debugInformation, rootCause, code.getSeverity());
    }

    public XmlDocumentCheckedException(Code code, Object arg, String debugInformation, Throwable rootCause, int severity) {
        this(code, new Object[]{arg}, debugInformation, rootCause, severity);
    }

    public XmlDocumentCheckedException(Code code, Object[] args, String debugInformation, Throwable rootCause, int severity) {
        super(code, args, debugInformation, rootCause, severity);
        XmlDocumentCheckedException.registerCode(Codes.GENERAL_ERROR);
        XmlDocumentCheckedException.registerCode(Codes.INCOMPATIBLE_DOCUMENT_TYPE);
        XmlDocumentCheckedException.registerCode(Codes.DOCUMENT_LOAD_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.NULL_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.CHILD_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.CLONE_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_NODE_NAME);
        XmlDocumentCheckedException.registerCode(Codes.ERROR_ON_CHILD_REMOVE);
        XmlDocumentCheckedException.registerCode(Codes.PARENT_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_INDEX);
    }

    public XmlDocumentCheckedException(String debugInformation, Throwable rootCause) {
        NfbCheckedException.Code mappedCode;
        NfbCheckedException ex;
        NfbCheckedException.Code code;
        XmlDocumentCheckedException.registerCode(Codes.GENERAL_ERROR);
        XmlDocumentCheckedException.registerCode(Codes.INCOMPATIBLE_DOCUMENT_TYPE);
        XmlDocumentCheckedException.registerCode(Codes.DOCUMENT_LOAD_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.NULL_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.CHILD_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.CLONE_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_NODE_NAME);
        XmlDocumentCheckedException.registerCode(Codes.ERROR_ON_CHILD_REMOVE);
        XmlDocumentCheckedException.registerCode(Codes.PARENT_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_INDEX);
        if (rootCause instanceof NfbCheckedException && (code = (ex = (NfbCheckedException)rootCause).getCode()) instanceof Code && (mappedCode = code.getMappedCode()) instanceof Code) {
            this.mCode = mappedCode;
            this.mArgs = ex.getArgs();
        }
        if (this.mCode == null) {
            this.mCode = Codes.GENERAL_ERROR;
            this.mArgs = new Serializable[]{rootCause};
        }
        this.mDebugInformation = debugInformation;
        this.mRootCause = rootCause;
        this.mSeverity = this.mCode.getSeverity();
    }

    public XmlDocumentCheckedException(String debugInformation, Throwable rootCause, int severity) {
        NfbCheckedException.Code mappedCode;
        NfbCheckedException ex;
        NfbCheckedException.Code code;
        XmlDocumentCheckedException.registerCode(Codes.GENERAL_ERROR);
        XmlDocumentCheckedException.registerCode(Codes.INCOMPATIBLE_DOCUMENT_TYPE);
        XmlDocumentCheckedException.registerCode(Codes.DOCUMENT_LOAD_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.NULL_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.CHILD_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.CLONE_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_NODE_NAME);
        XmlDocumentCheckedException.registerCode(Codes.ERROR_ON_CHILD_REMOVE);
        XmlDocumentCheckedException.registerCode(Codes.PARENT_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_INDEX);
        if (rootCause instanceof NfbCheckedException && (code = (ex = (NfbCheckedException)rootCause).getCode()) instanceof Code && (mappedCode = code.getMappedCode()) instanceof NfbCheckedException.Code) {
            this.mCode = mappedCode;
            this.mArgs = ex.getArgs();
        }
        if (this.mCode == null) {
            this.mCode = Codes.GENERAL_ERROR;
            this.mArgs = new Serializable[]{rootCause};
        }
        this.mDebugInformation = debugInformation;
        this.mRootCause = rootCause;
        this.mSeverity = severity;
    }

    public XmlDocumentCheckedException(Object arg, String debugInformation, Throwable rootCause) {
        NfbCheckedException.Code mappedCode;
        NfbCheckedException ex;
        NfbCheckedException.Code code;
        XmlDocumentCheckedException.registerCode(Codes.GENERAL_ERROR);
        XmlDocumentCheckedException.registerCode(Codes.INCOMPATIBLE_DOCUMENT_TYPE);
        XmlDocumentCheckedException.registerCode(Codes.DOCUMENT_LOAD_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.NULL_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.CHILD_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.CLONE_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_NODE_NAME);
        XmlDocumentCheckedException.registerCode(Codes.ERROR_ON_CHILD_REMOVE);
        XmlDocumentCheckedException.registerCode(Codes.PARENT_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_INDEX);
        if (rootCause instanceof NfbCheckedException && (code = (ex = (NfbCheckedException)rootCause).getCode()) instanceof Code && (mappedCode = code.getMappedCode()) instanceof NfbCheckedException.Code) {
            this.mCode = mappedCode;
        }
        if (this.mCode == null) {
            this.mCode = Codes.GENERAL_ERROR;
        }
        this.mArgs = arg != null ? (arg instanceof Serializable ? new Serializable[]{(Serializable)arg} : new Serializable[]{arg.toString()}) : new Serializable[0];
        this.mDebugInformation = debugInformation;
        this.mRootCause = rootCause;
        this.mSeverity = this.mCode.getSeverity();
    }

    public XmlDocumentCheckedException(Object[] args, String debugInformation, Throwable rootCause, int severity) {
        NfbCheckedException.Code mappedCode;
        NfbCheckedException ex;
        NfbCheckedException.Code code;
        XmlDocumentCheckedException.registerCode(Codes.GENERAL_ERROR);
        XmlDocumentCheckedException.registerCode(Codes.INCOMPATIBLE_DOCUMENT_TYPE);
        XmlDocumentCheckedException.registerCode(Codes.DOCUMENT_LOAD_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.NULL_ROOT_ELEMENT);
        XmlDocumentCheckedException.registerCode(Codes.CHILD_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.CLONE_FAILED);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_NODE_NAME);
        XmlDocumentCheckedException.registerCode(Codes.ERROR_ON_CHILD_REMOVE);
        XmlDocumentCheckedException.registerCode(Codes.PARENT_NOT_FOUND);
        XmlDocumentCheckedException.registerCode(Codes.INVALID_INDEX);
        if (rootCause instanceof NfbCheckedException && (code = (ex = (NfbCheckedException)rootCause).getCode()) instanceof Code && (mappedCode = code.getMappedCode()) instanceof NfbCheckedException.Code) {
            this.mCode = mappedCode;
        }
        if (this.mCode == null) {
            this.mCode = Codes.GENERAL_ERROR;
        }
        if (args != null) {
            int length = args.length;
            this.mArgs = new Serializable[length];
            for (int i = 0; i < length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                this.mArgs[i] = arg instanceof Serializable ? (Serializable)arg : arg.toString();
            }
        } else {
            this.mArgs = new Serializable[0];
        }
        this.mDebugInformation = debugInformation;
        this.mRootCause = rootCause;
        this.mSeverity = severity;
    }

    @Override
    protected NfbCheckedException.Code getDefaultCode() {
        return Codes.GENERAL_ERROR;
    }

    public static class Code
    extends NfbCheckedException.Code {
        private static final long serialVersionUID = 1L;

        private Code(String code, String message, int severity) {
            super(code, null, message, severity);
        }

        protected Code(String code, Code mappedCode, String message, int severity) {
            super(code, mappedCode, message, severity);
        }
    }

    public static interface Codes {
        public static final Code GENERAL_ERROR = new Code("XmlDocument:GeneralError", "A general error has occurred: {0}", 2);
        public static final Code INCOMPATIBLE_DOCUMENT_TYPE = new Code("XmlDocument:IncompatibleDocumentType", "The XmlDocument implementation, {0} is incompatible with {1}", 3);
        public static final Code DOCUMENT_LOAD_FAILED = new Code("XmlDocument:DocumentLoadFailed", "Failed to load the document: {0}", 3);
        public static final Code INVALID_ROOT_ELEMENT = new Code("XmlDocument:InvalidRootElement", "The root element of the document is not appropriate for this adapter type.", 3);
        public static final Code NULL_ROOT_ELEMENT = new Code("XmlDocument:NullRootElement", "The root element of the document is null.", 3);
        public static final Code CHILD_NOT_FOUND = new Code("XmlDocument:ChildNotFound", "Child not found, path: {0}", 4);
        public static final Code CLONE_FAILED = new Code("XmlDocument:CloneFailed", "Could not clone the child node: {0}", 4);
        public static final Code INVALID_NODE_NAME = new Code("XmlDocument:InvalidNodeName", "An invalid node name was found: {0}", 3);
        public static final Code ERROR_ON_CHILD_REMOVE = new Code("XmlDocument:ErrorOnChildRemove", "Error occured when trying to remove child: {0}", 3);
        public static final Code PARENT_NOT_FOUND = new Code("XmlDocument:ParentNotFound", "Parent node not found: {0}", 3);
        public static final Code INVALID_INDEX = new Code("XmlDocument:InvalidIndex", "Invalid index.", 3);
    }
}

