/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.exception;

import com.nfbsoftware.exception.NfbCheckedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class NfbRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected static final String TO_STRING_MESSAGE_FORMAT = "[{0} - {1} - {2} - {3}]";
    private static final Map<String, Code> CODE_MAP = new HashMap<String, Code>(31);
    protected Code mCode;
    protected Serializable[] mArgs;
    protected String mDebugInformation;
    protected Throwable mRootCause;
    protected int mSeverity;
    protected String mStackTraceString;

    public NfbRuntimeException() {
    }

    public NfbRuntimeException(Code code, Object[] args, String debugInformation, Throwable rootCause) {
        this.mCode = code;
        this.mDebugInformation = debugInformation;
        this.mRootCause = rootCause;
        this.mSeverity = 1;
        if (args != null) {
            int length = args.length;
            this.mArgs = new Serializable[length];
            for (int i = 0; i < length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                this.mArgs[i] = arg instanceof Serializable ? (Serializable)arg : arg.toString();
            }
        } else {
            this.mArgs = new Serializable[0];
        }
    }

    protected abstract Code getDefaultCode();

    public String getCodeName() {
        return this.mCode.getCode();
    }

    public Code getCode() {
        return this.mCode;
    }

    public Serializable[] getArgs() {
        return this.mArgs;
    }

    public String getDebugInformation() {
        return this.mDebugInformation;
    }

    public Throwable getRootCause() {
        return this.mRootCause;
    }

    public int getSeverity() {
        return this.mSeverity;
    }

    public String getSeverityAsString() {
        switch (this.mSeverity) {
            case 1: {
                return "FATAL";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "WARNING";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "SUCCESS";
            }
            case 6: {
                return "DEBUG";
            }
        }
        return "ERROR";
    }

    @Override
    public String getMessage() {
        String result = MessageFormat.format(this.mCode.getMessage().trim(), this.getArgs()).trim();
        return result;
    }

    private String buildStackTrace() {
        StringBuffer results = new StringBuffer(this.buildStackTrace(this));
        Throwable rootCause = this.mRootCause;
        while (rootCause != null) {
            results.append("Caused by: ");
            if (rootCause instanceof NfbCheckedException) {
                results.append(this.buildStackTrace(rootCause));
                rootCause = ((NfbCheckedException)rootCause).getRootCause();
                continue;
            }
            if (rootCause instanceof NfbRuntimeException) {
                results.append(this.buildStackTrace(rootCause));
                rootCause = ((NfbRuntimeException)rootCause).getRootCause();
                continue;
            }
            results.append(this.buildStackTrace(rootCause));
            rootCause = null;
        }
        return results.toString();
    }

    private String buildStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String s = writer.toString();
        if (t == this) {
            int i = s.indexOf("\n\tat ");
            if (i != -1) {
                String stackTraceString = s.substring(i);
                return stackTraceString;
            }
            return "";
        }
        return s;
    }

    public String getStackTraceString() {
        if (this.mStackTraceString == null) {
            this.mStackTraceString = this.buildStackTrace();
        }
        return this.mStackTraceString;
    }

    @Override
    public String toString() {
        Object[] args = new Object[]{this.getSeverityAsString(), this.mCode, this.mDebugInformation, this.getMessage()};
        return MessageFormat.format(TO_STRING_MESSAGE_FORMAT, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Code getCode(String codeName) {
        Map<String, Code> map = CODE_MAP;
        synchronized (map) {
            return CODE_MAP.get(codeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerCode(Code code) {
        Map<String, Code> map = CODE_MAP;
        synchronized (map) {
            String codeName = code.getCode();
            if (!CODE_MAP.containsKey(codeName)) {
                CODE_MAP.put(codeName, code);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    protected static class Code
    implements Serializable {
        static final long serialVersionUID = 0L;
        private Code mMappedCode;
        private String mCode;
        private String mMessage;

        protected Code(String code, Code mappedCode, String message) {
            this.mCode = code;
            this.mMappedCode = mappedCode;
            this.mMessage = message;
        }

        public String getCode() {
            return this.mCode;
        }

        public Code getMappedCode() {
            return this.mMappedCode;
        }

        public String getMessage() {
            return this.mMessage;
        }

        public String toString() {
            return this.mCode;
        }
    }
}

