/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.xml;

import com.nfbsoftware.xml.IXmlDocument;
import com.nfbsoftware.xml.IXmlElement;
import com.nfbsoftware.xml.IXslDocument;
import com.nfbsoftware.xml.XmlDocument;
import com.nfbsoftware.xml.exception.XmlDocumentCheckedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XslDocument
implements IXslDocument {
    private static final long serialVersionUID = 1L;
    private transient DocumentBuilder mDocumentBuilder;
    private IXmlDocument mXslDocument;
    private IXmlElement mXslElement;
    private transient TransformerFactory mTransformerFactory;

    public XslDocument() throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + "<init>()";
        try {
            this.mXslDocument = new XmlDocument();
            this.mXslElement = this.mXslDocument.getRootElement();
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    public XslDocument(File file) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + "<init>(File)";
        try {
            this.mXslDocument = new XmlDocument(file);
            this.mXslElement = this.mXslDocument.getRootElement();
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    public XslDocument(File file, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + "<init>(File, String)";
        try {
            this.mXslDocument = new XmlDocument(file, enc);
            this.mXslElement = this.mXslDocument.getRootElement();
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    public XslDocument(InputStream in) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + "<init>(InputStream)";
        try {
            this.mXslDocument = new XmlDocument(in);
            this.mXslElement = this.mXslDocument.getRootElement();
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    public XslDocument(InputStream in, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + "<init>(InputStream, String)";
        try {
            this.mXslDocument = new XmlDocument(in, enc);
            this.mXslElement = this.mXslDocument.getRootElement();
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    public XslDocument(Reader reader) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + "<init>(Reader)";
        try {
            this.mXslDocument = new XmlDocument(reader);
            this.mXslElement = this.mXslDocument.getRootElement();
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    public XslDocument(String xml) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + "<init>(String)";
        try {
            this.mXslDocument = new XmlDocument(xml);
            this.mXslElement = this.mXslDocument.getRootElement();
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    @Override
    public void load(File file) throws XmlDocumentCheckedException {
        this.mXslDocument.load(file);
    }

    @Override
    public void load(File file, String enc) throws XmlDocumentCheckedException {
        this.mXslDocument.load(file, enc);
    }

    @Override
    public void load(InputStream in) throws XmlDocumentCheckedException {
        this.mXslDocument.load(in);
    }

    @Override
    public void load(InputStream in, String enc) throws XmlDocumentCheckedException {
        this.mXslDocument.load(in, enc);
    }

    @Override
    public void load(Reader reader) throws XmlDocumentCheckedException {
        this.mXslDocument.load(reader);
    }

    @Override
    public void load(String xml) throws XmlDocumentCheckedException {
        this.mXslDocument.load(xml);
    }

    @Override
    public String transform(File xmlFile) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transform(File)";
        String results = null;
        try {
            XmlDocument doc = new XmlDocument(xmlFile);
            results = this.transformNodeFromXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public String transform(File xmlFile, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transform(File, String)";
        String results = null;
        try {
            XmlDocument doc = new XmlDocument(xmlFile, enc);
            results = this.transformNodeFromXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public String transform(InputStream stream) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transform(InputStream)";
        String results = null;
        try {
            XmlDocument doc = new XmlDocument(stream);
            results = this.transformNodeFromXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public String transform(InputStream stream, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transform(InputStream, String)";
        String results = null;
        try {
            XmlDocument doc = new XmlDocument(stream, enc);
            results = this.transformNodeFromXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public String transform(IXmlElement xmlElement) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transform(IXmlElement)";
        String results = null;
        try {
            XmlDocument doc = new XmlDocument(xmlElement.getRootNode(), xmlElement.getDocument());
            results = this.transformNodeFromXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public String transform(Reader reader) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transform(Reader)";
        String results = null;
        try {
            XmlDocument doc = new XmlDocument(reader);
            results = this.transformNodeFromXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public String transform(String xml) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transform(String)";
        String results = null;
        try {
            results = this.transformNodeFromString(xml);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public IXmlDocument transformToXmlDocument(File xmlFile) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transformToXmlDocument(File)";
        XmlDocument results = null;
        try {
            XmlDocument doc = new XmlDocument(xmlFile);
            results = this.transformNodeFromXmlDataToXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public IXmlDocument transformToXmlDocument(File xmlFile, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transformToXmlDocument(File, String)";
        XmlDocument results = null;
        try {
            XmlDocument doc = new XmlDocument(xmlFile, enc);
            results = this.transformNodeFromXmlDataToXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public IXmlDocument transformToXmlDocument(InputStream stream) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transformToXmlDocument(InputStream)";
        XmlDocument results = null;
        try {
            XmlDocument doc = new XmlDocument(stream);
            results = this.transformNodeFromXmlDataToXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public IXmlDocument transformToXmlDocument(InputStream stream, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transformToXmlDocument(InputStream, String)";
        XmlDocument results = null;
        try {
            XmlDocument doc = new XmlDocument(stream, enc);
            results = this.transformNodeFromXmlDataToXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public IXmlDocument transformToXmlDocument(IXmlElement xmlElement) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transformToXmlDocument(IXmlElement)";
        XmlDocument results = null;
        try {
            XmlDocument doc = new XmlDocument(xmlElement.getRootNode(), xmlElement.getDocument());
            results = this.transformNodeFromXmlDataToXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public IXmlDocument transformToXmlDocument(Reader reader) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transformToXmlDocument(Reader)";
        XmlDocument results = null;
        try {
            XmlDocument doc = new XmlDocument(reader);
            results = this.transformNodeFromXmlDataToXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public IXmlDocument transformToXmlDocument(String xml) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transformToXmlDocument(String)";
        XmlDocument results = null;
        try {
            XmlDocument doc = new XmlDocument(xml);
            results = this.transformNodeFromXmlDataToXmlData(doc);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    public String toString() {
        if (this.mXslDocument != null) {
            return this.mXslDocument.toString();
        }
        return super.toString();
    }

    private DocumentBuilder createDocumentBuilder() throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".createDocumentBuilder()";
        try {
            DocumentBuilderFactory docBuidlerFactory = DocumentBuilderFactory.newInstance();
            docBuidlerFactory.setNamespaceAware(true);
            return docBuidlerFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String transformNodeFromString(String xslStr) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".transformNodeFromString(String)";
        ByteArrayInputStream input = new ByteArrayInputStream(xslStr.getBytes());
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (this.mTransformerFactory == null) {
                XslDocument xslDocument = this;
                synchronized (xslDocument) {
                    this.mTransformerFactory = TransformerFactory.newInstance();
                }
            }
            StringReader xslStream = new StringReader(this.mXslDocument.toString());
            Transformer transformer = this.mTransformerFactory.newTransformer(new StreamSource(xslStream));
            transformer.transform(new StreamSource(input), new StreamResult(out));
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String transformNodeFromXmlData(IXmlDocument xmlNode) throws XmlDocumentCheckedException {
        IXmlDocument iXmlDocument = xmlNode;
        synchronized (iXmlDocument) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (this.mTransformerFactory == null) {
                    XslDocument xslDocument = this;
                    synchronized (xslDocument) {
                        this.mTransformerFactory = TransformerFactory.newInstance();
                    }
                }
                StringReader xslStream = new StringReader(this.mXslDocument.toString());
                Transformer transformer = this.mTransformerFactory.newTransformer(new StreamSource(xslStream));
                transformer.transform(new DOMSource(xmlNode.getDocument()), new StreamResult(out));
                return out.toString("UTF-8");
            }
            catch (Exception e) {
                throw new XmlDocumentCheckedException("XmlDocument.transfromNodeFromString", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlDocument transformNodeFromXmlDataToXmlData(IXmlDocument xmlNode) throws XmlDocumentCheckedException {
        IXmlDocument iXmlDocument = xmlNode;
        synchronized (iXmlDocument) {
            try {
                if (this.mTransformerFactory == null) {
                    XslDocument xslDocument = this;
                    synchronized (xslDocument) {
                        this.mTransformerFactory = TransformerFactory.newInstance();
                    }
                }
                StringReader xslStream = new StringReader(this.mXslDocument.toString());
                Transformer transformer = this.mTransformerFactory.newTransformer(new StreamSource(xslStream));
                XslDocument xslDocument = this;
                synchronized (xslDocument) {
                    if (this.mDocumentBuilder == null) {
                        this.mDocumentBuilder = this.createDocumentBuilder();
                    }
                }
                Document doc = this.mDocumentBuilder.newDocument();
                transformer.transform(new DOMSource(xmlNode.getDocument()), new DOMResult(doc));
                return new XmlDocument(doc, doc);
            }
            catch (Exception e) {
                throw new XmlDocumentCheckedException("XmlDocument.transfromNodeFromXmlDocumentToXmlDocument", e);
            }
        }
    }
}

