/*
 * Decompiled with CFR 0.152.
 */
package com.nullprogram.guide;

import com.nullprogram.guide.Arch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public final class NativeGuide {
    private static final String LOGGER_NAME = NativeGuide.class.getName();
    private static final Logger LOG = Logger.getLogger(LOGGER_NAME);
    private static final int BUFFER_SIZE = 10240;
    private static final int BITS_32 = 32;
    private static final int BITS_64 = 64;
    private static final String SEP = System.getProperty("path.separator");
    private static Arch architecture = Arch.UNKNOWN;
    private static String base = null;

    private NativeGuide() {
    }

    private static synchronized void setUpTemp() throws IOException {
        if (base != null) {
            return;
        }
        File dir = new File(System.getProperty("java.io.tmpdir"), "NativeGuide-" + System.getProperty("user.name"));
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException("NativeGuide directory is a file");
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
        String orig = System.getProperty("java.library.path");
        base = dir.getAbsolutePath();
        System.setProperty("java.library.path", orig + SEP + base);
        try {
            Field sysPath = ClassLoader.class.getDeclaredField("sys_paths");
            sysPath.setAccessible(true);
            sysPath.set(null, null);
        }
        catch (Exception e) {
            LOG.severe("Could not modify java.library.path property.");
        }
    }

    public static void load(Arch arch, String path) throws IOException {
        if (NativeGuide.isArchitecture(arch)) {
            NativeGuide.setUpTemp();
            System.load(NativeGuide.copyToTemp(path).getAbsolutePath());
        }
    }

    public static void prepare(Arch arch, String path) throws IOException {
        if (NativeGuide.isArchitecture(arch)) {
            NativeGuide.setUpTemp();
            NativeGuide.copyToTemp(path);
        }
    }

    public static void load(String arch, String os, String path) throws IOException {
        if (NativeGuide.isArchitecture(arch, os)) {
            NativeGuide.setUpTemp();
            System.load(NativeGuide.copyToTemp(path).getAbsolutePath());
        }
    }

    public static void prepare(String arch, String os, String path) throws IOException {
        if (NativeGuide.isArchitecture(arch, os)) {
            NativeGuide.setUpTemp();
            NativeGuide.copyToTemp(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyToTemp(String path) throws IOException {
        String name = new File(path).getName();
        File file = new File(base, name);
        boolean exists = file.isFile();
        InputStream in = NativeGuide.class.getResourceAsStream(path);
        in = new BufferedInputStream(in);
        in.available();
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] bytes = new byte[10240];
            int n = 0;
            while (n != -1) {
                out.write(bytes, 0, n);
                n = in.read(bytes);
            }
        }
        catch (IOException e) {
            if (!exists) {
                throw e;
            }
            LOG.info(name + " exists but could not be written.");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    LOG.warning(name + " could not close file.");
                }
            }
        }
        file.deleteOnExit();
        return file;
    }

    private static boolean isArchitecture(Arch arch) {
        if (architecture == Arch.UNKNOWN) {
            architecture = NativeGuide.getArchitecture();
        }
        return architecture == arch;
    }

    private static boolean isArchitecture(String arch, String os) {
        return System.getProperty("os.arch").equals(arch) && System.getProperty("os.name").equals(os);
    }

    public static Arch getArchitecture() {
        String os;
        int bits = 32;
        if (System.getProperty("os.arch").indexOf("64") != -1) {
            bits = 64;
        }
        if ((os = System.getProperty("os.name")).startsWith("Windows")) {
            if (bits == 32) {
                return Arch.WINDOWS_32;
            }
            return Arch.WINDOWS_64;
        }
        if (os.equals("Linux")) {
            if (bits == 32) {
                return Arch.LINUX_32;
            }
            return Arch.LINUX_64;
        }
        if (os.equals("Mac OS X")) {
            if (bits == 32) {
                return Arch.MAC_32;
            }
            return Arch.MAC_64;
        }
        return Arch.UNKNOWN;
    }
}

