/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.commons.java8;

import com.numdata.commons.java8.NioTools;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestNioTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnzip() throws Exception {
        Path dir = Files.createTempDirectory("root", new FileAttribute[0]);
        try {
            System.out.println("Temporary directory: " + dir);
            System.out.println("Create 'test.zip'");
            Path zipFile = dir.resolve("test.zip");
            try (ZipOutputStream zip = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
                ZipEntry subdir = new ZipEntry("subdir/");
                zip.putNextEntry(subdir);
                zip.putNextEntry(new ZipEntry("subdir/test.txt"));
                zip.write("Hello".getBytes());
            }
            System.out.println("Unzip 'test.zip'");
            NioTools.unzip((Path)dir, (Path)zipFile);
            System.out.println("Check contents directory");
            TreeSet<String> expectedFiles = new TreeSet<String>();
            expectedFiles.add("");
            expectedFiles.add("test.zip");
            expectedFiles.add("subdir");
            expectedFiles.add("subdir" + File.separator + "test.txt");
            Collection actualFiles = Files.walk(dir, new FileVisitOption[0]).map(dir::relativize).map(Object::toString).collect(Collectors.toCollection(TreeSet::new));
            Assert.assertEquals((String)"Unexpected list of files after unzip", expectedFiles, (Object)actualFiles);
        }
        finally {
            System.out.println("Delete " + dir + " directory");
            NioTools.deleteRecursively((Path)dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFilesRecursively() throws IOException {
        Path root = Files.createTempDirectory("root", new FileAttribute[0]);
        try {
            List<Path> dirs = Arrays.asList(Paths.get("dir1", new String[0]), Paths.get("dir1", "dir2"), Paths.get("dir3", new String[0]), Paths.get("dir4", new String[0]), Paths.get("dir4", "dir5"));
            List<Path> files = Arrays.asList(Paths.get("file1", new String[0]), Paths.get("file2", new String[0]), Paths.get("dir1", "dir2", "file3"), Paths.get("dir1", "file4"), Paths.get("dir4", "file5"));
            Path src = root.resolve("src");
            Files.createDirectory(src, new FileAttribute[0]);
            for (Path path : dirs) {
                Files.createDirectory(src.resolve(path), new FileAttribute[0]);
            }
            byte[] fileContents = "Generated for unit test".getBytes();
            for (Path file : files) {
                Files.write(src.resolve(file), fileContents, new OpenOption[0]);
            }
            Path path = root.resolve("dir1");
            Path dir2 = root.resolve("dir2");
            Path dir2link = root.resolve("dir2link");
            Path dir3 = root.resolve("dir3");
            for (int i = 0; i <= 2; ++i) {
                Path resolved;
                Path dest;
                switch (i) {
                    default: {
                        Files.createDirectory(path, new FileAttribute[0]);
                        dest = path;
                        break;
                    }
                    case 1: {
                        Files.createDirectory(dir2, new FileAttribute[0]);
                        try {
                            Files.createSymbolicLink(dir2link, dir2, new FileAttribute[0]);
                        }
                        catch (FileSystemException e) {
                            System.err.println("WARNING: Symbolic link cannot be tested on this platform: " + e);
                            System.err.println("The test will continue, but 'dir2link' will be a directory instead of a symbolic link to a directory.");
                        }
                        dest = dir2link;
                        break;
                    }
                    case 2: {
                        dest = dir3;
                    }
                }
                NioTools.copyFilesRecursively((Path)src, (Path)dest);
                Assert.assertTrue((String)"Missing directory", (boolean)Files.isDirectory(dest, new LinkOption[0]));
                for (Path dir : dirs) {
                    resolved = dest.resolve(dir);
                    Assert.assertTrue((String)("Missing directory: " + resolved), (boolean)Files.isDirectory(resolved, new LinkOption[0]));
                }
                for (Path file : files) {
                    resolved = dest.resolve(file);
                    Assert.assertTrue((String)("Missing file: " + resolved), (boolean)Files.isRegularFile(resolved, new LinkOption[0]));
                    Assert.assertArrayEquals((String)("Unexpected contents for file: " + resolved), (byte[])fileContents, (byte[])Files.readAllBytes(resolved));
                }
            }
        }
        finally {
            NioTools.deleteRecursively((Path)root);
        }
    }
}

