/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.commons.java8;

import com.numdata.commons.java8.StreamTools;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamTools {
    @Test
    public void testStream() {
        Assert.assertEquals((String)"StreamTools.stream( [ 1, 2, 3 ] )", Arrays.asList(1, 2, 3), StreamTools.stream(Arrays.asList(1, 2, 3)).collect(Collectors.toList()));
    }

    @Test
    public void testToMap() {
        Object input = new HashMap<String, Integer>();
        input.put("one", 1);
        input.put("two", 2);
        input.put("three", 3);
        TreeMap<String, Integer> expected = new TreeMap<String, Integer>();
        expected.put("one", 1);
        expected.put("three", 3);
        expected.put("two", 2);
        Assert.assertEquals((String)"[ 'one'->1, 'two'->2, 'three'->3 ].collect( StreamTools.toMap(...) )", expected, input.entrySet().stream().collect(StreamTools.toMap(Map.Entry::getKey, Map.Entry::getValue, TreeMap::new)));
        try {
            input = Arrays.asList(new AbstractMap.SimpleEntry<String, Integer>("nodupe", 1), new AbstractMap.SimpleEntry<String, Integer>("dupe", 2), new AbstractMap.SimpleEntry<String, Integer>("dupe", 3));
            input.stream().collect(StreamTools.toMap(Map.Entry::getKey, Map.Entry::getValue, HashMap::new));
            Assert.fail((String)"[ 'nodupe'->1, 'dupe'->2, 'dupe'->3 ].collect( StreamTools.toMap(...) ) should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testToSet() {
        Assert.assertSame((String)"StreamTools.toSet( Stream.empty() )", Collections.emptySet(), (Object)StreamTools.toSet(Stream.empty()));
        Assert.assertEquals((String)"StreamTools.toSet( Stream.of( 3, 3, 2, 2, 1, 1 ) )", new HashSet<Integer>(Arrays.asList(1, 2, 3)), (Object)StreamTools.toSet((Stream)((Stream)Stream.of(3, 3, 2, 2, 1, 1).parallel())));
        Assert.assertEquals((String)"StreamTools.toSet( Stream.of( 3, 3, 2, 2, 1, 1 ), TreeSet::new )", new TreeSet<Integer>(Arrays.asList(1, 2, 3)), (Object)StreamTools.toSet((Stream)((Stream)Stream.of(3, 3, 2, 2, 1, 1).parallel()), TreeSet::new));
        Assert.assertEquals((String)"StreamTools.toSet( Stream.of( 3, 3, 2, 2, 1, 1 ), LinkedHashSet::new )", new LinkedHashSet<Integer>(Arrays.asList(3, 2, 1)), (Object)StreamTools.toSet((Stream)((Stream)Stream.of(3, 3, 2, 2, 1, 1).parallel()), LinkedHashSet::new));
        StreamTools.toSet((Stream)((Stream)Proxy.newProxyInstance(Stream.class.getClassLoader(), new Class[]{Stream.class}, (proxy, method, args) -> {
            Assert.assertEquals((String)("Expected call to reduce() method, but was: " + method), (Object)"reduce", (Object)method.getName());
            Assert.assertEquals((String)("Expected call to reduce(identity,accumulator,combiner) method, but was: " + method), (long)3L, (long)args.length);
            Assert.assertSame((String)"Expected 'identity' to be 'Collections.emptySet()'", Collections.emptySet(), (Object)args[0]);
            BiFunction accumulator = (BiFunction)args[1];
            Set set = (Set)accumulator.apply(Collections.emptySet(), 1);
            Assert.assertEquals((String)"'accumulator.apply( empty, 1 )' should return 'LinkedHashSet'", LinkedHashSet.class, set.getClass());
            Assert.assertEquals((String)"'accumulator.apply( empty, 1 )' should have added 1", new LinkedHashSet<Integer>(Collections.singletonList(1)), (Object)set);
            Assert.assertSame((String)"'accumulator.apply( set, 2 )' should return 'set'", (Object)set, accumulator.apply(set, 2));
            Assert.assertEquals((String)"'accumulator.apply( set, 2 )' have added 2", new LinkedHashSet<Integer>(Arrays.asList(1, 2)), (Object)set);
            BinaryOperator combiner = (BinaryOperator)args[2];
            Set empty = Collections.emptySet();
            HashSet<Integer> set1 = new HashSet<Integer>(Arrays.asList(1, 2, 3));
            HashSet<Integer> set2 = new HashSet<Integer>(Arrays.asList(3, 4, 5));
            Assert.assertSame((String)"'combiner.apply( empty, set1 )' should return 'set1'", set1, combiner.apply(empty, set1));
            Assert.assertSame((String)"'combiner.apply( set1, empty )' should return 'set1'", set1, combiner.apply(set1, empty));
            Assert.assertSame((String)"'combiner.apply( set1, set2 )' should return 'set1'", set1, combiner.apply(set1, set2));
            Assert.assertEquals((String)"'combiner.apply( set1, set2 )' should updated 'set1'", new HashSet<Integer>(Arrays.asList(1, 2, 3, 4, 5)), set1);
            Assert.assertEquals((String)"'combiner.apply( set1, set2 )' should have left 'set2' unchanged", new HashSet<Integer>(Arrays.asList(3, 4, 5)), set2);
            return Collections.emptySet();
        })), LinkedHashSet::new);
    }
}

