/*
 * Decompiled with CFR 0.152.
 */
package com.numdata.commons.java8;

import com.numdata.commons.java8.WaitingFutureTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWaitingFutureTask {
    private ExecutorService _executor;

    @Before
    public void setUp() {
        this._executor = new ThreadPoolExecutor(0, 100, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
    }

    @After
    public void tearDown() throws Exception {
        System.out.println("Shut down executor");
        this._executor.shutdownNow();
        this._executor.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Executor failed to shutdown!?", (boolean)this._executor.isTerminated());
    }

    @Test
    public void testCancel() throws Exception {
        int i;
        int[] state = new int[]{0};
        boolean[] finishFast = new boolean[]{false};
        WaitingFutureTask task = new WaitingFutureTask(() -> {
            System.out.println("task: Started");
            state[0] = 1;
            try {
                Thread.sleep(1000L);
                state[0] = 2;
                System.out.println("task: Time out #1");
            }
            catch (InterruptedException e) {
                state[0] = 3;
                System.out.println("task: Interrupted #1");
            }
            try {
                for (int i = 0; i < 100 && !finishFast[0]; ++i) {
                    Thread.sleep(10L);
                }
                Thread.sleep(20L);
                state[0] = 4;
                System.out.println("task: Time out #2");
            }
            catch (InterruptedException e) {
                state[0] = 5;
                System.out.println("task: Interrupted #2");
            }
        }, null);
        System.out.println("Execute task");
        this._executor.execute((Runnable)task);
        System.out.println("Waiting for start");
        for (i = 0; state[0] == 0 && i < 100; ++i) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)"Expected task to be started", (long)1L, (long)state[0]);
        System.out.println("Cancel without waiting");
        task.cancel(true);
        for (i = 0; state[0] == 1 && i < 100; ++i) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)"Expected task to be interrupted, but still running", (long)3L, (long)state[0]);
        Thread.sleep(10L);
        Assert.assertEquals((String)"Expected task to remain running 10ms later", (long)3L, (long)state[0]);
        System.out.println("Cancel and wait for timeout");
        Assert.assertFalse((String)"Cancel should timeout after 10ms", (boolean)task.cancelAndWait(true, 20, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"Expected task to be interrupted, but still running", (long)3L, (long)state[0]);
        System.out.println("Cancel and wait");
        finishFast[0] = true;
        task.cancelAndWait(true);
        Assert.assertEquals((String)"Expected task to be interrupted, but still running", (long)4L, (long)state[0]);
    }

    @Test
    public void testGet() throws Exception {
        int i;
        int[] state = new int[]{0};
        boolean[] finishFast = new boolean[]{false};
        WaitingFutureTask task = new WaitingFutureTask(() -> {
            System.out.println("task: Started");
            state[0] = 1;
            try {
                Thread.sleep(1000L);
                state[0] = 2;
                System.out.println("task: Time out #1");
            }
            catch (InterruptedException e) {
                state[0] = 3;
                System.out.println("task: Interrupted #1");
                try {
                    for (int i = 0; i < 100 && !finishFast[0]; ++i) {
                        Thread.sleep(10L);
                    }
                    Thread.sleep(20L);
                    state[0] = 4;
                    System.out.println("task: Finished");
                }
                catch (InterruptedException e2) {
                    state[0] = 5;
                    System.out.println("task: Interrupted #2");
                }
            }
        }, null);
        System.out.println("Execute task");
        this._executor.execute((Runnable)task);
        System.out.println("Waiting for start");
        for (i = 0; state[0] == 0 && i < 100; ++i) {
            Thread.sleep(10L);
        }
        System.out.println("Cancel without waiting");
        task.cancel(true);
        for (i = 0; state[0] == 1 && i < 100; ++i) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)"Expected task to be interrupted, but still running", (long)3L, (long)state[0]);
        System.out.println("Request result using 'get()' with timeout");
        finishFast[0] = true;
        try {
            task.get(20L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected CancellationException");
        }
        catch (CancellationException e) {
            Assert.assertEquals((String)"Expected task to be finished", (long)4L, (long)state[0]);
        }
        System.out.println("Request result using 'get()'");
        try {
            task.get();
            Assert.fail((String)"Expected CancellationException");
        }
        catch (CancellationException e) {
            Assert.assertEquals((String)"Expected task to be finished", (long)4L, (long)state[0]);
        }
    }
}

