/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm;

import com.ursful.framework.orm.DynamicDataSource;
import com.ursful.framework.orm.option.DMOptions;
import com.ursful.framework.orm.option.H2Options;
import com.ursful.framework.orm.option.MySQLOptions;
import com.ursful.framework.orm.option.OracleOptions;
import com.ursful.framework.orm.option.PostgreSQLOptions;
import com.ursful.framework.orm.option.SQLServerOptions;
import com.ursful.framework.orm.support.DatabaseTypeHolder;
import com.ursful.framework.orm.support.IRealConnection;
import com.ursful.framework.orm.support.Options;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DataSourceManager {
    private List<IRealConnection> connectionInterface = new ArrayList<IRealConnection>();
    private Map<DataSource, String> databaseTypeMap = new HashMap<DataSource, String>();
    private List<Options> optionsList = Arrays.asList(new H2Options(), new MySQLOptions(), new SQLServerOptions(), new OracleOptions(), new PostgreSQLOptions(), new DMOptions());
    private Map<String, Options> optionsCache = new HashMap<String, Options>();
    private Map<Class, DataSource> dataSourceMap = new HashMap<Class, DataSource>();
    private Map<String, DataSource> packageDataSourceMap = new HashMap<String, DataSource>();
    private Map<String, DataSource> classDataSourceMap = new HashMap<String, DataSource>();
    private DataSource dataSource;

    public List<IRealConnection> getRealConnection() {
        return this.connectionInterface;
    }

    public void register(IRealConnection connection) {
        if (!this.connectionInterface.contains(connection)) {
            this.connectionInterface.add(connection);
        }
    }

    public void deregister(IRealConnection connection) {
        this.connectionInterface.remove(connection);
    }

    public void register(Class clazz, DataSource dataSource) {
        this.classDataSourceMap.put(clazz.getName(), dataSource);
    }

    public void register(String pkg, DataSource dataSource) {
        this.packageDataSourceMap.put(pkg, dataSource);
    }

    public DataSourceManager() {
    }

    public DataSourceManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getRawDataSource(DataSource current) {
        DataSource raw = current;
        if (current instanceof DynamicDataSource) {
            DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)current);
            raw = dynamicDataSource.currentDataSource();
        }
        return raw;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Options getOptions(String type) {
        return this.optionsCache.get(type);
    }

    public Options getOptions(Class clazz, Class serviceClass) {
        String productName = this.getProductName(clazz, serviceClass);
        Options options = this.optionsCache.get(productName);
        if (options == null) {
            for (Options temp : this.optionsList) {
                if (!productName.contains(temp.keyword().toUpperCase(Locale.ROOT))) continue;
                options = temp;
                break;
            }
            this.optionsCache.put(productName, options);
        }
        return options;
    }

    public void registerOptions(Options options) {
        if (!this.optionsList.contains(options)) {
            this.optionsList.add(options);
        }
    }

    private DataSource getPackageDataSource(Class clazz) {
        if (clazz == null || this.packageDataSourceMap.isEmpty()) {
            return null;
        }
        String name = clazz.getName();
        for (String key : this.packageDataSourceMap.keySet()) {
            if (!name.startsWith(key)) continue;
            DataSource ds = this.packageDataSourceMap.get(key);
            this.dataSourceMap.put(clazz, ds);
            return ds;
        }
        return null;
    }

    public void clearPatternDataSource() {
        this.dataSourceMap.clear();
        this.classDataSourceMap.clear();
        this.packageDataSourceMap.clear();
    }

    private DataSource getPatternDataSource(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName();
        DataSource ds = this.classDataSourceMap.get(name);
        if (ds != null) {
            this.dataSourceMap.put(clazz, ds);
            return ds;
        }
        for (String key : this.packageDataSourceMap.keySet()) {
            if (!name.startsWith(key)) continue;
            ds = this.packageDataSourceMap.get(key);
            this.dataSourceMap.put(clazz, ds);
            return ds;
        }
        return null;
    }

    public DataSource getDataSource(Class clazz, Class serviceClass) {
        if (clazz == null && serviceClass == null) {
            return this.dataSource;
        }
        DataSource source = null;
        if (serviceClass != null && this.dataSourceMap.containsKey(serviceClass)) {
            source = this.dataSourceMap.get(serviceClass);
            return source;
        }
        if (clazz != null && this.dataSourceMap.containsKey(clazz)) {
            source = this.dataSourceMap.get(clazz);
            return source;
        }
        source = this.getPatternDataSource(serviceClass);
        if (source != null) {
            return source;
        }
        source = this.getPatternDataSource(clazz);
        if (source != null) {
            return source;
        }
        if (serviceClass != null) {
            this.dataSourceMap.put(serviceClass, this.dataSource);
        }
        if (clazz != null) {
            this.dataSourceMap.put(clazz, this.dataSource);
        }
        return this.dataSource;
    }

    public Connection getConnection(Class clazz, Class serviceClass) {
        DataSource source = this.getDataSource(clazz, serviceClass);
        DataSource raw = this.getRawDataSource(source);
        Connection connection = DataSourceUtils.getConnection((DataSource)raw);
        DatabaseTypeHolder.set(this.getProductName(raw, connection));
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProductName(DataSource raw) {
        String type = this.databaseTypeMap.get(raw);
        if (type != null) {
            return type;
        }
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)raw);
            String string = this.getProductName(raw, connection);
            return string;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)raw);
        }
    }

    public String getProductName(Class clazz, Class serviceClass) {
        DataSource temp = this.getDataSource(clazz, serviceClass);
        DataSource raw = this.getRawDataSource(temp);
        return this.getProductName(raw);
    }

    public String getProductName(DataSource source, Connection connection) {
        String type = this.databaseTypeMap.get(source);
        if (type != null) {
            return type;
        }
        try {
            String productName = connection.getMetaData().getDatabaseProductName().toUpperCase(Locale.ROOT);
            this.databaseTypeMap.put(source, productName);
            return productName;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void close(Class clazz, Class serviceClass, ResultSet rs, Statement stmt, Connection conn) {
        DataSource source = this.getDataSource(clazz, serviceClass);
        DataSource raw = this.getRawDataSource(source);
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)raw);
            DatabaseTypeHolder.remove();
        }
    }
}

