/*
 * Decompiled with CFR 0.152.
 */
package com.ursful.framework.orm.support;

import com.ursful.framework.orm.support.PreChangeCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ChangeHolder {
    private static final ThreadLocal<String> threadLocal = new ThreadLocal();
    private static Map<String, List<PreChangeCache>> changeCacheMap = new HashMap<String, List<PreChangeCache>>();

    public static void cache(PreChangeCache cache) {
        String key = ChangeHolder.get();
        List<PreChangeCache> caches = changeCacheMap.get(key);
        if (caches == null) {
            caches = new ArrayList<PreChangeCache>();
        }
        caches.add(cache);
        changeCacheMap.put(key, caches);
    }

    public static void change() {
        String key = ChangeHolder.get();
        List<PreChangeCache> changeCaches = changeCacheMap.get(key);
        if (changeCaches != null) {
            for (PreChangeCache changeCache : changeCaches) {
                changeCache.changed();
            }
        }
        ChangeHolder.remove();
    }

    public static void remove() {
        String key = threadLocal.get();
        changeCacheMap.remove(key);
        threadLocal.remove();
    }

    public static void set(String change) {
        if (change == null) {
            ChangeHolder.remove();
        } else {
            threadLocal.set(change);
        }
    }

    public static String get() {
        return threadLocal.get();
    }
}

