/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.transaction;

import com.objectsql.support.ChangeHolder;
import com.objectsql.utils.ORMUtils;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class TransactionManager
extends DataSourceTransactionManager {
    public TransactionManager(DataSource dataSource) {
        super(dataSource);
    }

    public TransactionManager() {
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        String key = "transaction-" + UUID.randomUUID().toString();
        ORMUtils.handleDebugInfo(TransactionManager.class, "begin", key);
        ChangeHolder.set(key);
        super.doBegin(transaction, definition);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        ORMUtils.handleDebugInfo(TransactionManager.class, "commit", ChangeHolder.get());
        super.doCommit(status);
        ChangeHolder.change();
    }

    protected void doRollback(DefaultTransactionStatus status) {
        ORMUtils.handleDebugInfo(TransactionManager.class, "rollback", ChangeHolder.get());
        ChangeHolder.remove();
        super.doRollback(status);
    }
}

