/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.capability.resources.IPropertyAccessCapability;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class PropertyAccessCapability
implements IPropertyAccessCapability {
    private KubernetesResource resource;

    public PropertyAccessCapability(IResource resource) {
        if (resource instanceof KubernetesResource) {
            this.resource = (KubernetesResource)resource;
        }
    }

    @Override
    public String asString(String path) {
        ModelNode node = JBossDmrExtentions.get(this.resource.getNode(), null, path);
        if (!node.isDefined()) {
            throw new IPropertyAccessCapability.UnresolvablePathException();
        }
        return node.asString();
    }

    @Override
    public Map<String, Object> asMap(String path) {
        return this.asMap(JBossDmrExtentions.get(this.resource.getNode(), null, path));
    }

    private Map<String, Object> asMap(ModelNode node) {
        if (!node.isDefined()) {
            throw new IPropertyAccessCapability.UnresolvablePathException();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        block10: for (String key : node.keys()) {
            ModelNode value = node.get(key);
            switch (value.getType()) {
                case OBJECT: {
                    result.put(key, this.asMap(value));
                    continue block10;
                }
                case LIST: {
                    result.put(key, this.asList(value));
                }
                case STRING: {
                    result.put(key, value.asString());
                    continue block10;
                }
                case INT: {
                    result.put(key, value.asInt());
                    continue block10;
                }
                case BIG_INTEGER: {
                    result.put(key, value.asBigInteger());
                    continue block10;
                }
                case BIG_DECIMAL: {
                    result.put(key, value.asBigDecimal());
                    continue block10;
                }
                case LONG: {
                    result.put(key, value.asBigDecimal());
                    continue block10;
                }
                case BOOLEAN: {
                    result.put(key, value.asBoolean());
                    continue block10;
                }
            }
            result.put(key, value.asString());
        }
        return result;
    }

    private List<Object> asList(ModelNode node) {
        ArrayList<Object> list = new ArrayList<Object>();
        block10: for (ModelNode entry : node.asList()) {
            switch (entry.getType()) {
                case OBJECT: {
                    list.add(this.asMap(entry));
                    continue block10;
                }
                case LIST: {
                    list.add(this.asList(entry));
                }
                case STRING: {
                    list.add(entry.asString());
                    continue block10;
                }
                case INT: {
                    list.add(entry.asInt());
                    continue block10;
                }
                case BIG_INTEGER: {
                    list.add(entry.asBigInteger());
                    continue block10;
                }
                case BIG_DECIMAL: {
                    list.add(entry.asBigDecimal());
                    continue block10;
                }
                case LONG: {
                    list.add(entry.asBigDecimal());
                    continue block10;
                }
                case BOOLEAN: {
                    list.add(entry.asBoolean());
                    continue block10;
                }
            }
            list.add(entry.asString());
        }
        return list;
    }

    @Override
    public boolean isSupported() {
        return this.resource != null;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

