/*
 * Decompiled with CFR 0.152.
 */
package com.parisesoftware.datastructure.simulation;

import com.parisesoftware.datastructure.model.Customer;
import com.parisesoftware.datastructure.queue.IQueue;
import com.parisesoftware.datastructure.queue.QueueImpl;
import java.util.concurrent.ThreadLocalRandom;

public class CustomerSimulation {
    private IQueue<Customer> line = new QueueImpl();
    private int numMinsRemaining = 720;
    private int minsUntilNextCustomer = 0;
    private int lineLength = 0;
    private int minInt;
    private int maxInt;

    public CustomerSimulation() {
        this.minInt = 1;
        this.maxInt = 5;
    }

    public CustomerSimulation(int min, int max) {
        this.minInt = min;
        this.maxInt = max;
    }

    public int randNum(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public void addCustomer() {
        Customer customer = this.createCustomerWithRandomTimeLeft();
        this.minsUntilNextCustomer = this.randNum(this.minInt, this.maxInt);
        this.line.insertElement((Comparable)customer);
        ++this.lineLength;
    }

    private Customer createCustomerWithRandomTimeLeft() {
        return new Customer(this.randNum(this.minInt, this.maxInt));
    }

    public int getLineLength() {
        return this.lineLength;
    }

    private boolean hasNewCustomerArrived() {
        return this.minsUntilNextCustomer <= 0;
    }

    private void addCustomerIfNewCustomerHasArrived() {
        if (this.hasNewCustomerArrived()) {
            this.addCustomer();
        }
    }

    public void increment() {
        Customer curCustomer;
        int i;
        --this.numMinsRemaining;
        --this.minsUntilNextCustomer;
        this.addCustomerIfNewCustomerHasArrived();
        for (i = 0; i < this.getLineLength() - 1; ++i) {
            if (this.line.search(i) == null) continue;
            curCustomer = (Customer)this.line.search(i).getData();
            curCustomer.minuteGoesBy();
        }
        for (i = 0; i < this.getLineLength() - 1; ++i) {
            if (this.line.search(i) == null || !(curCustomer = (Customer)this.line.search(i).getData()).getCanBeServed()) continue;
            this.line.removeElement(i);
            --this.lineLength;
            break;
        }
    }

    public void simulationController() {
        while (this.numMinsRemaining >= 0) {
            this.increment();
        }
        System.out.println("At the end of the 720 minute period, there are " + this.lineLength + " customers waiting in the line.");
    }
}

