/*
 * Decompiled with CFR 0.152.
 */
package com.paymentplugins;

import com.paymentplugins.Configuration;
import com.paymentplugins.HttpResponseException;
import com.paymentplugins.PaymentPluginsException;
import com.paymentplugins.SimpleXMLNode;
import com.paymentplugins.XMLNode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.DatatypeConverter;

public class Http {
    private Configuration config;

    public Http(Configuration config) {
        this.config = config;
    }

    public XMLNode processRequest(String uri, Method method) {
        return this.processRequest(uri, method, null);
    }

    public XMLNode processRequest(String uri, Method method, String body) {
        StringBuilder builder = new StringBuilder();
        HttpURLConnection connection = null;
        XMLNode node = null;
        try {
            int i;
            connection = this.buildConnection(uri, method.getMethod());
            if (body != null) {
                connection.getOutputStream().write(body.getBytes());
            }
            int httpCode = connection.getResponseCode();
            this.checkResponseCode(httpCode);
            InputStream stream = connection.getInputStream();
            BufferedInputStream buff = new BufferedInputStream(stream);
            while ((i = buff.read()) != -1) {
                builder.append((char)i);
            }
            node = SimpleXMLNode.parse(builder.toString());
        }
        catch (IOException e) {
            throw new PaymentPluginsException(e.getMessage());
        }
        catch (Exception e) {
            throw new PaymentPluginsException(e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return node;
    }

    private HttpURLConnection buildConnection(String uri, String method) throws Exception {
        HttpURLConnection connection = null;
        String url = this.config.getBaseUrl() + uri;
        try {
            URL connectionUrl = new URL(url);
            connection = (HttpURLConnection)connectionUrl.openConnection();
            connection.setRequestMethod(method);
            connection.addRequestProperty("Authorization", this.getAuthorizationHeader());
            connection.addRequestProperty("Content-Type", "application/json");
            connection.addRequestProperty("Accept", "application/xml");
            connection.setDoOutput(true);
            connection.setConnectTimeout(60000);
        }
        catch (MalformedURLException e) {
            throw new Exception("MalformedURLException: " + e.getMessage());
        }
        catch (IOException e) {
            throw new Exception("IOException: " + e.getMessage());
        }
        return connection;
    }

    private String getAuthorizationHeader() {
        byte[] auths = (this.config.getPublickey() + ":" + this.config.getPrivatekey()).getBytes();
        String authorizations = DatatypeConverter.printBase64Binary((byte[])auths);
        String authHeader = String.format("Basic %s", authorizations);
        return authHeader;
    }

    private void checkResponseCode(int httpCode) {
        HTTP_CODE codeType = this.isResponseCodeError(httpCode);
        if (codeType != null) {
            throw new HttpResponseException(codeType.getMessage());
        }
    }

    private HTTP_CODE isResponseCodeError(int httpCode) {
        for (Error error : Error.values()) {
            if (error.getCode() != httpCode) continue;
            return error;
        }
        return null;
    }

    public static enum Error implements HTTP_CODE
    {
        SC_BAD_REQUEST(400, "Bad Request"),
        SC_UNAUTHORIZED(401, "Unauthorized "),
        SC_FORBIDDEN(403, "Forbidden"),
        SC_NOT_FOUND(404, "Not Found"),
        SC_METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
        SC_INTERNAL_SERVER_ERROR(500, "Server Error"),
        SC_NOT_IMPLEMENTED(501, "Not Implemented"),
        SC_BAD_GATEWAY(502, "Bad Gateway"),
        SC_SERVICE_UNAVAILABLE(503, "Service Unavailable"),
        SC_GATEWAY_TIMEOUT(504, "Gateway Timeout");

        private int code;
        private String message;

        private Error(int code, String message) {
            this.code = code;
            this.message = message;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static enum Success implements HTTP_CODE
    {
        SC_OK(200, "OK"),
        SC_CREATED(201, "Created"),
        SC_ACCEPTED(202, "Accepted"),
        SC_NON_AUTHORITATIVE_INFORMATION(203, "Non Authoritative Information"),
        SC_NO_CONTENT(204, "No Content");

        private int code;
        private String message;

        private Success(int code, String message) {
            this.code = code;
            this.message = message;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static interface HTTP_CODE {
        public int getCode();

        public String getMessage();
    }

    public static enum Method {
        GET("GET"),
        POST("POST");

        private String method;

        private Method(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

