package com.paymentplugins;

public class Environment {

	public static final Environment DEVELOPMENT = new Environment(Environment.Type.Development);
	public static final Environment SANDBOX = new Environment(Environment.Type.Sandbox);
	public static final Environment PRODUCTION = new Environment(Environment.Type.Production);

	public static enum Type{
		Development("http://localhost:8080/paymentplugins/v1/merchants", ""),
		Sandbox("https://api.sandbox.paymentplugins.com:443", "ssl/api_paymentplugins_com.crt"), 
		Production("https://api.paymentplugins.com:443", "ssl/api_paymentplugins_com.crt");
		
		private String url;
		private String cert;
		
		private Type(String url, String cert){
			this.url = url;
			this.cert = cert;
		}
		
		public String getUrl(){
			return this.url;
		}
		
		public String getCert(){
			return this.cert;
		}
	}

	private Type type;
	
	public Environment(Environment.Type type){
		this.type = type;
	}
	
	public String getBaseUrl(){
		return this.type.getUrl();
	}
	
	public String getCert(){
		return this.type.getCert();
	}
}
