/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.node;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import com.google.inject.Singleton;
import com.proofpoint.node.ApplicationName;
import com.proofpoint.node.ApplicationVersion;
import com.proofpoint.node.NodeConfig;
import com.proofpoint.node.PlatformVersion;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

@Singleton
public class NodeInfo {
    private static final Pattern HOST_EXCEPTION_MESSAGE_PATTERN = Pattern.compile("([-_a-zA-Z0-9]+):.*");
    private final String application;
    private final String applicationVersion;
    private final String platformVersion;
    private final String environment;
    private final String pool;
    private final String nodeId;
    private final String location;
    private final String instanceId = UUID.randomUUID().toString();
    private final InetAddress internalIp;
    private final String internalHostname;
    private final String externalAddress;
    private final InetAddress bindIp;
    private final long startTime = System.currentTimeMillis();

    public NodeInfo(String environment) {
        this("test-application", new NodeConfig().setEnvironment(environment));
    }

    public NodeInfo(String application, NodeConfig config) {
        this(application, "", "", config);
    }

    @Inject
    public NodeInfo(@ApplicationName String application, @ApplicationVersion String applicationVersion, @PlatformVersion String platformVersion, NodeConfig config) {
        this(application, applicationVersion, platformVersion, config.getEnvironment(), config.getPool(), config.getNodeId(), config.getNodeInternalIp(), config.getNodeInternalHostname(), config.getNodeBindIp(), config.getNodeExternalAddress(), config.getLocation());
    }

    public NodeInfo(String application, String applicationVersion, String platformVersion, String environment, String pool, String nodeId, InetAddress internalIp, String internalHostname, InetAddress bindIp, String externalAddress, String location) {
        Objects.requireNonNull(application, "application is null");
        Objects.requireNonNull(applicationVersion, "applicationVersion is null");
        Objects.requireNonNull(platformVersion, "platformVersion is null");
        Objects.requireNonNull(environment, "environment is null");
        Objects.requireNonNull(pool, "pool is null");
        Preconditions.checkArgument((boolean)environment.matches("[a-z0-9][_a-z0-9]*"), (String)"environment '%s' is invalid", (Object)environment);
        Preconditions.checkArgument((boolean)pool.matches("[a-zA-Z0-9][-_a-zA-Z0-9]*"), (String)"pool '%s' is invalid", (Object)pool);
        this.application = application;
        this.applicationVersion = applicationVersion;
        this.platformVersion = platformVersion;
        this.environment = environment;
        this.pool = pool;
        if (nodeId != null) {
            Preconditions.checkArgument((boolean)nodeId.matches("[A-Za-z0-9][_A-Za-z0-9-]*"), (String)"nodeId '%s' is invalid", (Object)nodeId);
            this.nodeId = nodeId;
        } else {
            this.nodeId = UUID.randomUUID().toString();
        }
        this.location = location != null ? location : "/" + this.nodeId;
        this.internalIp = internalIp != null ? internalIp : NodeInfo.findPublicIp();
        if (internalHostname != null) {
            Preconditions.checkArgument((internalHostname.equals("localhost") || internalHostname.matches("[a-z0-9][-_a-z0-9]*(?:\\.[a-z0-9][-_a-z0-9]*)+") ? 1 : 0) != 0, (Object)String.format("hostname '%s' is invalid", internalHostname));
            this.internalHostname = internalHostname;
        } else {
            this.internalHostname = this.findPublicHostname();
        }
        this.bindIp = bindIp != null ? bindIp : InetAddresses.fromInteger((int)0);
        this.externalAddress = externalAddress != null ? externalAddress : InetAddresses.toAddrString((InetAddress)this.internalIp);
    }

    @Managed
    public String getApplication() {
        return this.application;
    }

    @Managed
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Managed
    public String getPlatformVersion() {
        return this.platformVersion;
    }

    @Managed
    public String getEnvironment() {
        return this.environment;
    }

    @Managed
    public String getPool() {
        return this.pool;
    }

    @Managed
    public String getNodeId() {
        return this.nodeId;
    }

    @Managed
    public String getLocation() {
        return this.location;
    }

    @Managed
    public InetAddress getInternalIp() {
        return this.internalIp;
    }

    @Managed
    public String getInternalHostname() {
        return this.internalHostname;
    }

    @Managed
    public String getExternalAddress() {
        return this.externalAddress;
    }

    @Managed
    public InetAddress getBindIp() {
        return this.bindIp;
    }

    @Managed
    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeId", (Object)this.nodeId).add("instanceId", (Object)this.instanceId).add("internalIp", (Object)this.internalIp).add("externalAddress", (Object)this.externalAddress).add("bindIp", (Object)this.bindIp).add("startTime", this.startTime).toString();
    }

    private static InetAddress findPublicIp() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (NodeInfo.isGoodV4Address(localAddress)) {
                return localAddress;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (localAddress == null) {
            try {
                localAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            }
            catch (UnknownHostException e) {
                throw new AssertionError((Object)"Could not get local ip address");
            }
        }
        for (NetworkInterface networkInterface : NodeInfo.getGoodNetworkInterfaces()) {
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                if (!NodeInfo.isGoodV4Address(address)) continue;
                return address;
            }
        }
        for (NetworkInterface networkInterface : NodeInfo.getGoodNetworkInterfaces()) {
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                if (!NodeInfo.isGoodV6Address(address)) continue;
                return address;
            }
        }
        return localAddress;
    }

    private static List<NetworkInterface> getGoodNetworkInterfaces() {
        ImmutableList.Builder builder = ImmutableList.builder();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : interfaces != null ? Collections.list(interfaces) : ImmutableList.of()) {
                try {
                    if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                    builder.add((Object)networkInterface);
                }
                catch (Exception exception) {}
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return builder.build();
    }

    private static boolean isGoodV4Address(InetAddress address) {
        return address instanceof Inet4Address && !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress();
    }

    private static boolean isGoodV6Address(InetAddress address) {
        return address instanceof Inet6Address && !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress();
    }

    private String findPublicHostname() {
        try {
            return InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            Matcher matcher = HOST_EXCEPTION_MESSAGE_PATTERN.matcher(e.getMessage());
            if (matcher.matches()) {
                return matcher.group(1).toLowerCase();
            }
            return InetAddresses.toUriString((InetAddress)this.internalIp);
        }
    }
}

